"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTestFlyoutOpen = void 0;
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _constants = require("../../../../../../common/constants");
var _manual_test_runs = require("../../../state/manual_test_runs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTestFlyoutOpen = () => {
  const testNowRuns = (0, _reactRedux.useSelector)(_manual_test_runs.testNowRunsSelector);
  const isOverview = (0, _reactRouterDom.useRouteMatch)({
    path: [_constants.OVERVIEW_ROUTE]
  });
  const isMonitorDetails = (0, _reactRouterDom.useRouteMatch)({
    path: [_constants.MONITOR_ROUTE]
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const flyoutTestOpen = (0, _react.useMemo)(() => {
    return Object.values(testNowRuns).find(value => {
      return value.isTestNowFlyoutOpen;
    });
  }, [testNowRuns]);
  const isSameMonitor = (flyoutTestOpen === null || flyoutTestOpen === void 0 ? void 0 : flyoutTestOpen.configId) === (isMonitorDetails === null || isMonitorDetails === void 0 ? void 0 : isMonitorDetails.params.monitorId);
  (0, _react.useEffect)(() => {
    if (!(isOverview !== null && isOverview !== void 0 && isOverview.isExact) && flyoutTestOpen && !isSameMonitor) {
      dispatch((0, _manual_test_runs.hideTestNowFlyoutAction)());
    }
  });
  return flyoutTestOpen;
};
exports.useTestFlyoutOpen = useTestFlyoutOpen;