"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallTickAxis = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _styles = require("../styles");
var _waterfall_chart_fixed_axis = require("../waterfall_chart_fixed_axis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaterfallTickAxis = ({
  showOnlyHighlightedNetworkRequests,
  setOnlyHighlighted,
  highlightedNetworkRequests,
  fetchedNetworkRequests,
  shouldRenderSidebar,
  barStyleAccessor,
  domain,
  tickFormat
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartTimeTicksContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false
  }, shouldRenderSidebar && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE
  }, highlightedNetworkRequests < fetchedNetworkRequests ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    role: "button",
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": "syntheticsWaterfallHideNonMatching",
    "aria-pressed": showOnlyHighlightedNetworkRequests,
    title: FILTER_COLLAPSE_REQUESTS_LABEL,
    "aria-label": FILTER_COLLAPSE_REQUESTS_LABEL,
    css: {
      marginTop: euiTheme.size.s,
      marginLeft: euiTheme.size.m,
      marginBottom: euiTheme.size.s,
      whiteSpace: 'nowrap',
      cursor: 'pointer',
      color: euiTheme.colors.textPrimary
    },
    onClick: () => {
      setOnlyHighlighted(!showOnlyHighlightedNetworkRequests);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: showOnlyHighlightedNetworkRequests ? 'eyeClosed' : 'eye',
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.waterfall.networkRequests.filteredOut",
    defaultMessage: "Filtered out"
  })))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      outline: 0,
      marginLeft: '-16px',
      height: 40
    },
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    "data-test-subj": "axisOnlyWrapper"
  }, /*#__PURE__*/_react.default.createElement(_waterfall_chart_fixed_axis.WaterfallChartFixedAxis, {
    domain: domain,
    barStyleAccessor: barStyleAccessor,
    tickFormat: tickFormat
  }))))));
};
exports.WaterfallTickAxis = WaterfallTickAxis;
const FILTER_COLLAPSE_REQUESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.pingList.synthetics.waterfall.filters.collapseRequestsLabel', {
  defaultMessage: 'Collapse to only show matching requests'
});