"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteParam = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _global_params = require("../../../state/global_params");
var _labels = require("../../monitors_page/management/monitor_list_table/labels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteParam = ({
  items,
  setIsDeleteModalVisible
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isDeleting,
    listOfParams
  } = (0, _reactRedux.useSelector)(_global_params.selectGlobalParamState);
  const name = items.map(({
    key
  }) => key).join(', ').slice(0, 50);
  (0, _react.useEffect)(() => {
    if (!isDeleting && (listOfParams !== null && listOfParams !== void 0 ? listOfParams : []).length === 0) {
      setIsDeleteModalVisible(false);
      dispatch(_global_params.getGlobalParamAction.get());
    }
  }, [isDeleting, setIsDeleteModalVisible, name, dispatch, listOfParams]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.synthetics.paramManagement.deleteParamNameLabel', {
      defaultMessage: 'Delete "{name}" param?',
      values: {
        name
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setIsDeleteModalVisible(false),
    onConfirm: () => {
      dispatch(_global_params.deleteGlobalParamsAction.get(items.map(({
        id
      }) => id)));
    },
    cancelButtonText: _labels.NO_LABEL,
    confirmButtonText: _labels.YES_LABEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: isDeleting
  });
};
exports.DeleteParam = DeleteParam;