"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportContentPackFlyout = ImportContentPackFlyout;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
var _content_pack_objects_list = require("./content_pack_objects_list");
var _requests = require("./content/requests");
var _content_pack_manifest = require("./content_pack_manifest");
var _errors = require("../../util/errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ImportContentPackFlyout({
  definition,
  onImport,
  onClose
}) {
  const {
    core: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [file, setFile] = (0, _react.useState)(null);
  const [contentPackObjects, setContentPackObjects] = (0, _react.useState)([]);
  const [selectedContentPackObjects, setSelectedContentPackObjects] = (0, _react.useState)([]);
  const [manifest, setManifest] = (0, _react.useState)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.streams.streamDetailDashboard.importContent', {
    defaultMessage: 'Import content pack'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: 'streams-content-import',
    multiple: false,
    initialPromptText: "Select a streams content file",
    fullWidth: true,
    onChange: async files => {
      if (files !== null && files !== void 0 && files.length) {
        const archiveFile = files.item(0);
        if (!archiveFile) return;
        setFile(archiveFile);
        try {
          const contentPackParsed = await (0, _requests.previewContent)({
            http,
            definition,
            file: archiveFile
          });
          setManifest({
            name: contentPackParsed.name,
            version: contentPackParsed.version,
            description: contentPackParsed.description
          });
          setContentPackObjects(contentPackParsed.entries);
        } catch (err) {
          setFile(null);
          notifications.toasts.addError(err, {
            title: _i18n.i18n.translate('xpack.streams.failedToPreviewContentError', {
              defaultMessage: 'Failed to preview content pack'
            }),
            toastMessage: (0, _errors.getFormattedError)(err).message
          });
        }
      } else {
        setFile(null);
      }
    },
    display: 'large'
  }), file && manifest ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_content_pack_manifest.ContentPackMetadata, {
    manifest: manifest,
    readonly: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_content_pack_objects_list.ContentPackObjectsList, {
    objects: contentPackObjects,
    onSelectionChange: objects => setSelectedContentPackObjects(objects)
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose()
  }, "Cancel")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppModalFooterButton",
    disabled: !file || selectedContentPackObjects.length === 0,
    isLoading: isLoading,
    fill: true,
    onClick: async () => {
      if (!file) return;
      setIsLoading(true);
      try {
        await (0, _requests.importContent)({
          http,
          file,
          definition,
          include: {
            objects: {
              dashboards: selectedContentPackObjects.map(({
                id
              }) => id)
            }
          }
        });
        setIsLoading(false);
        setContentPackObjects([]);
        setFile(null);
        onImport();
      } catch (err) {
        setIsLoading(false);
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.streams.failedToImportContentError', {
            defaultMessage: 'Failed to import content pack'
          }),
          toastMessage: (0, _errors.getFormattedError)(err).message
        });
      }
    }
  }, _i18n.i18n.translate('xpack.streams.importContentPackFlyout.importToStream', {
    defaultMessage: 'Import to stream'
  }))))));
}