"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailRouting = StreamDetailRouting;
exports.StreamDetailRoutingImpl = StreamDetailRoutingImpl;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _use_timefilter = require("../../../hooks/use_timefilter");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _child_stream_list = require("./child_stream_list");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
var _management_bottom_bar = require("../management_bottom_bar");
var _preview_panel = require("./preview_panel");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamDetailRouting(props) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    core,
    dependencies
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    streams: {
      streamsRepositoryClient
    }
  } = dependencies.start;
  const {
    timeState$
  } = (0, _use_timefilter.useTimefilter)();
  return /*#__PURE__*/_react.default.createElement(_stream_routing_state_machine.StreamRoutingContextProvider, {
    definition: props.definition,
    refreshDefinition: props.refreshDefinition,
    core: core,
    data: data,
    timeState$: timeState$,
    streamsRepositoryClient: streamsRepositoryClient,
    forkSuccessNofitier: createForkSuccessNofitier({
      core,
      router
    })
  }, /*#__PURE__*/_react.default.createElement(StreamDetailRoutingImpl, null));
}
function StreamDetailRoutingImpl() {
  var _streamsListFetch$val, _streamsListFetch$val2;
  const {
    appParams,
    core
  } = (0, _use_kibana.useKibana)();
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  const {
    cancelChanges,
    saveChanges
  } = (0, _stream_routing_state_machine.useStreamRoutingEvents)();
  const definition = routingSnapshot.context.definition;
  const shouldDisplayBottomBar = routingSnapshot.matches({
    ready: {
      reorderingRules: 'reordering'
    }
  }) && routingSnapshot.can({
    type: 'routingRule.save'
  });
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const streamsListFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    return streamsRepositoryClient.fetch('GET /api/streams 2023-10-31', {
      signal
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [streamsRepositoryClient, definition] // Refetch streams when the definition changes
  );
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: routingSnapshot.can({
      type: 'routingRule.save'
    }) || routingSnapshot.can({
      type: 'routingRule.fork'
    }),
    history: appParams.history,
    http: core.http,
    navigateToUrl: core.application.navigateToUrl,
    openConfirm: core.overlays.openConfirm
  });
  const availableStreams = (_streamsListFetch$val = (_streamsListFetch$val2 = streamsListFetch.value) === null || _streamsListFetch$val2 === void 0 ? void 0 : _streamsListFetch$val2.streams.map(stream => stream.name)) !== null && _streamsListFetch$val !== void 0 ? _streamsListFetch$val : [];
  const isVerticalLayout = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _css.css)`
        overflow: auto;
      `,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    className: (0, _css.css)`
          overflow: auto;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    className: (0, _css.css)`
            display: flex;
            max-width: 100%;
            overflow: auto;
            flex-grow: 1;
          `,
    paddingSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    direction: isVerticalLayout ? 'vertical' : 'horizontal'
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 40,
    minSize: "150px",
    tabIndex: 0,
    paddingSize: "s",
    color: "subdued",
    className: (0, _css.css)`
                    overflow: auto;
                    display: flex;
                  `
  }, /*#__PURE__*/_react.default.createElement(_child_stream_list.ChildStreamList, {
    availableStreams: availableStreams
  })), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    accountForScrollbars: "both"
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 60,
    tabIndex: 0,
    minSize: "300px",
    paddingSize: "s",
    className: (0, _css.css)`
                    display: flex;
                    flex-direction: column;
                  `
  }, /*#__PURE__*/_react.default.createElement(_preview_panel.PreviewPanel, null))))), shouldDisplayBottomBar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_management_bottom_bar.ManagementBottomBar, {
    confirmButtonText: _i18n.i18n.translate('xpack.streams.streamDetailRouting.change', {
      defaultMessage: 'Change routing'
    }),
    onCancel: cancelChanges,
    onConfirm: saveChanges,
    isLoading: routingSnapshot.matches({
      ready: {
        reorderingRules: 'updatingStream'
      }
    }),
    disabled: !routingSnapshot.can({
      type: 'routingRule.save'
    }),
    insufficientPrivileges: !routingSnapshot.can({
      type: 'routingRule.save'
    })
  }))));
}
const createForkSuccessNofitier = ({
  core,
  router
}) => streamName => core.notifications.toasts.addSuccess({
  title: _i18n.i18n.translate('xpack.streams.streamDetailRouting.saved', {
    defaultMessage: 'Stream saved'
  }),
  text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppSaveOrUpdateChildrenOpenStreamInNewTabButton",
    size: "s",
    target: "_blank",
    href: router.link('/{key}/management/{tab}', {
      path: {
        key: streamName,
        tab: 'route'
      }
    })
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.view', {
    defaultMessage: 'Open stream in new tab'
  })))), core)
});