"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = Wrapper;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _use_stream_detail = require("../../../hooks/use_stream_detail");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _streams_app_page_template = require("../../streams_app_page_template");
var _stream_badges = require("../../stream_badges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Wrapper({
  tabs,
  streamId,
  tab
}) {
  var _tabs$tab;
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    definition
  } = (0, _use_stream_detail.useStreamDetail)();
  const tabMap = Object.fromEntries(Object.entries(tabs).map(([tabName, currentTab]) => {
    return [tabName, {
      href: router.link('/{key}/management/{tab}', {
        path: {
          key: streamId,
          tab: tabName
        }
      }),
      label: currentTab.label,
      content: currentTab.content
    }];
  }));
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPageHeader, {
    paddingSize: "l",
    bottomBorder: "extended",
    breadcrumbs: [{
      href: router.link('/'),
      text: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "arrowLeft",
        size: "s",
        flush: "left"
      }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.breadcrumb', {
        defaultMessage: 'Streams'
      }))
    }],
    css: (0, _react.css)`
          background: ${euiTheme.colors.backgroundBasePlain};
        `,
    pageTitle: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "baseline"
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.manageStreamTitle', {
      defaultMessage: 'Manage stream {streamId}',
      values: {
        streamId
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react2.default.createElement(_stream_badges.DiscoverBadgeButton, {
      definition: definition
    }), _streamsSchema.Streams.UnwiredStream.GetResponse.is(definition) && /*#__PURE__*/_react2.default.createElement(_stream_badges.ClassicStreamBadge, null), /*#__PURE__*/_react2.default.createElement(_stream_badges.LifecycleBadge, {
      lifecycle: definition.effective_lifecycle
    }))),
    tabs: Object.entries(tabMap).map(([tabKey, {
      label,
      href
    }]) => ({
      label,
      href,
      isSelected: tab === tabKey
    }))
  }), /*#__PURE__*/_react2.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Body, null, (_tabs$tab = tabs[tab]) === null || _tabs$tab === void 0 ? void 0 : _tabs$tab.content));
}