"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditLifecycleModal = EditLifecycleModal;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _indexLifecycleManagementCommonShared = require("@kbn/index-lifecycle-management-common-shared");
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _use_kibana = require("../../../hooks/use_kibana");
var _rollover_condition = require("./helpers/rollover_condition");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _use_wired_streams = require("../../../hooks/use_wired_streams");
var _errors = require("../../../util/errors");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditLifecycleModal({
  action,
  ...options
}) {
  if (action === 'none') {
    return null;
  }
  if (action === 'dsl') {
    return /*#__PURE__*/_react.default.createElement(DslModal, options);
  }
  if (action === 'ilm') {
    return /*#__PURE__*/_react.default.createElement(IlmModal, options);
  }
  return /*#__PURE__*/_react.default.createElement(InheritModal, options);
}
const isInvalidRetention = value => {
  const num = Number(value);
  return isNaN(num) || num < 1 || num % 1 > 0;
};
function DslModal({
  closeModal,
  definition,
  updateInProgress,
  updateLifecycle
}) {
  var _existingRetention$va;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const timeUnits = [{
    name: 'Days',
    value: 'd'
  }, {
    name: 'Hours',
    value: 'h'
  }, {
    name: 'Minutes',
    value: 'm'
  }, {
    name: 'Seconds',
    value: 's'
  }];
  const existingRetention = (0, _streamsSchema.isDslLifecycle)(definition.stream.ingest.lifecycle) ? (0, _helpers.parseDuration)(definition.stream.ingest.lifecycle.dsl.data_retention) : undefined;
  const [selectedUnit, setSelectedUnit] = (0, _react.useState)(existingRetention && timeUnits.find(unit => unit.value === existingRetention.unit) || timeUnits[0]);
  const [retentionValue, setRetentionValue] = (0, _react.useState)(existingRetention && ((_existingRetention$va = existingRetention.value) === null || _existingRetention$va === void 0 ? void 0 : _existingRetention$va.toString()) || '1');
  const [noRetention, toggleNoRetention] = (0, _useToggle.default)((0, _streamsSchema.isDslLifecycle)(definition.stream.ingest.lifecycle) && !existingRetention);
  const [showUnitMenu, {
    on: openUnitMenu,
    off: closeUnitMenu
  }] = (0, _reactHooks.useBoolean)(false);
  const invalidRetention = (0, _react.useMemo)(() => isInvalidRetention(retentionValue) && !noRetention, [retentionValue, noRetention]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.editRetention', {
    defaultMessage: 'Edit data retention for stream'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.setCustomDsl', {
    defaultMessage: 'Specify a custom data retention period for this stream.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "streamsAppDslModalDaysField",
    value: retentionValue,
    onChange: e => setRetentionValue(e.target.value),
    disabled: noRetention,
    fullWidth: true,
    isInvalid: invalidRetention,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: showUnitMenu,
      panelPaddingSize: "none",
      closePopover: closeUnitMenu,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "streamsAppDslModalButton",
        disabled: noRetention,
        iconType: "arrowDown",
        iconSide: "right",
        color: "text",
        onClick: openUnitMenu
      }, selectedUnit.name)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: timeUnits.map(unit => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: unit.value,
        icon: selectedUnit.value === unit.value ? 'check' : 'empty',
        onClick: () => {
          closeUnitMenu();
          setSelectedUnit(unit);
        }
      }, unit.name))
    }))
  }), invalidRetention ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs"
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.invalidRetentionValue', {
    defaultMessage: 'A positive integer is required'
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.keepDataIndefinitely', {
      defaultMessage: 'Keep data indefinitely'
    }),
    checked: noRetention,
    onChange: () => toggleNoRetention()
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(ModalFooter, {
    definition: definition,
    confirmationLabel: "Save",
    closeModal: closeModal,
    confirmationIsDisabled: invalidRetention,
    onConfirm: () => {
      updateLifecycle({
        dsl: {
          data_retention: noRetention ? undefined : `${Number(retentionValue)}${selectedUnit.value}`
        }
      });
    },
    updateInProgress: updateInProgress
  }));
}
function IlmModal({
  closeModal,
  updateLifecycle,
  updateInProgress,
  getIlmPolicies,
  definition
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const ilmLocator = share.url.locators.get(_indexLifecycleManagementCommonShared.ILM_LOCATOR_ID);
  const existingLifecycle = definition.stream.ingest.lifecycle;
  const [selectedPolicy, setSelectedPolicy] = (0, _react.useState)((0, _streamsSchema.isIlmLifecycle)(existingLifecycle) ? existingLifecycle.ilm.policy : undefined);
  const [policies, setPolicies] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const phasesDescription = phases => {
      const desc = [];
      if (phases.hot) {
        const rolloverConditions = (0, _rollover_condition.rolloverCondition)(phases.hot.actions.rollover);
        desc.push(`Hot (${rolloverConditions ? 'rollover when ' + rolloverConditions : 'no rollover'})`);
      }
      if (phases.warm) {
        desc.push(`Warm after ${phases.warm.min_age}`);
      }
      if (phases.cold) {
        desc.push(`Cold after ${phases.cold.min_age}`);
      }
      if (phases.frozen) {
        desc.push(`Frozen after ${phases.frozen.min_age}`);
      }
      if (phases.delete) {
        desc.push(`Delete after ${phases.delete.min_age}`);
      } else {
        desc.push('Keep data indefinitely');
      }
      return desc.join(', ');
    };
    setIsLoading(true);
    getIlmPolicies().then(ilmPolicies => {
      const policyOptions = ilmPolicies.map(({
        name,
        policy
      }) => ({
        label: `${name}`,
        searchableLabel: name,
        checked: selectedPolicy === name ? 'on' : undefined,
        data: {
          phases: phasesDescription(policy.phases)
        }
      }));
      setPolicies(policyOptions);
    }).catch(error => {
      setErrorMessage((0, _errors.getFormattedError)(error).message);
    }).finally(() => setIsLoading(false));

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.attachIlm', {
    defaultMessage: 'Attach a lifecycle policy to this stream'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.selectIlmOrVisit1', {
    defaultMessage: 'Select a pre-defined policy or visit'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "streamsAppIlmModalIndexLifecyclePoliciesLink",
    target: "_blank",
    href: ilmLocator === null || ilmLocator === void 0 ? void 0 : ilmLocator.getRedirectUrl({
      page: 'policies_list'
    })
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.selectIlmOrVisit2', {
    defaultMessage: 'Index Lifecycle Policies'
  })), ' ', _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.selectIlmOrVisit3', {
    defaultMessage: 'to create a new one.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    singleSelection: true,
    isLoading: isLoading,
    options: policies,
    errorMessage: errorMessage,
    onChange: options => {
      var _options$find;
      setSelectedPolicy((_options$find = options.find(option => option.checked === 'on')) === null || _options$find === void 0 ? void 0 : _options$find.label);
      setPolicies(options);
    },
    listProps: {
      rowHeight: 45
    },
    renderOption: (option, searchValue) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, option.label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      className: "eui-displayBlock"
    }, /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, option.phases || ''))))
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)))), /*#__PURE__*/_react.default.createElement(ModalFooter, {
    definition: definition,
    confirmationLabel: "Attach policy",
    closeModal: closeModal,
    onConfirm: () => {
      if (selectedPolicy) {
        updateLifecycle({
          ilm: {
            policy: selectedPolicy
          }
        });
      }
    },
    confirmationIsDisabled: !selectedPolicy,
    updateInProgress: updateInProgress
  }));
}
function InheritModal({
  definition,
  ...options
}) {
  if (_streamsSchema.Streams.WiredStream.GetResponse.is(definition)) {
    return /*#__PURE__*/_react.default.createElement(InheritModalWired, (0, _extends2.default)({
      definition: definition
    }, options));
  } else if (_streamsSchema.Streams.UnwiredStream.GetResponse.is(definition)) {
    return /*#__PURE__*/_react.default.createElement(InheritModalUnwired, (0, _extends2.default)({
      definition: definition
    }, options));
  }
}
function InheritModalWired({
  definition,
  closeModal,
  updateInProgress,
  updateLifecycle
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    wiredStreams,
    isLoading: wiredStreamsLoading
  } = (0, _use_wired_streams.useWiredStreams)();
  const parents = (0, _react.useMemo)(() => {
    if (wiredStreamsLoading || !wiredStreams) {
      return undefined;
    }
    const ancestors = (0, _streamsSchema.getAncestors)(definition.stream.name);
    return wiredStreams.filter(stream => ancestors.includes(stream.name));
  }, [definition, wiredStreams, wiredStreamsLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.defaultLifecycleTitle', {
    defaultMessage: 'Set data retention to default'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.defaultLifecycleWiredDesc', {
    defaultMessage: 'All custom retention settings for this stream will be removed, resetting it to inherit data retention from'
  }), ' ', wiredStreamsLoading || !parents ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LinkToStream, {
    name: (0, _streamsSchema.findInheritedLifecycle)({
      ...definition.stream,
      ingest: {
        ...definition.stream.ingest,
        lifecycle: {
          inherit: {}
        }
      }
    }, parents).from
  }), ".")), /*#__PURE__*/_react.default.createElement(ModalFooter, {
    definition: definition,
    confirmationLabel: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.defaultLifecycleAction', {
      defaultMessage: 'Set to default'
    }),
    closeModal: closeModal,
    onConfirm: () => updateLifecycle({
      inherit: {}
    }),
    updateInProgress: updateInProgress
  }));
}
function InheritModalUnwired({
  definition,
  closeModal,
  updateInProgress,
  updateLifecycle
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.defaultLifecycleTitle', {
    defaultMessage: 'Set data retention to default'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.defaultLifecycleUnwiredDesc', {
    defaultMessage: 'All custom retention settings for this stream will be removed, resetting it to use the configuration of the template.'
  })), /*#__PURE__*/_react.default.createElement(ModalFooter, {
    definition: definition,
    confirmationLabel: "Set to default",
    closeModal: closeModal,
    onConfirm: () => updateLifecycle({
      inherit: {}
    }),
    updateInProgress: updateInProgress
  }));
}
function ModalFooter({
  definition,
  updateInProgress,
  confirmationLabel,
  confirmationIsDisabled,
  onConfirm,
  closeModal
}) {
  const {
    wiredStreams,
    isLoading: wiredStreamsLoading
  } = (0, _use_wired_streams.useWiredStreams)();
  const inheritingStreams = (0, _react.useMemo)(() => {
    if (!_streamsSchema.Streams.WiredStream.GetResponse.is(definition) || wiredStreamsLoading || !wiredStreams) {
      return [];
    }
    return (0, _streamsSchema.findInheritingStreams)(definition.stream, wiredStreams.filter(_streamsSchema.Streams.WiredStream.Definition.is)).filter(name => name !== definition.stream.name);
  }, [definition, wiredStreams, wiredStreamsLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, _streamsSchema.Streams.WiredStream.GetResponse.is(definition) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.lifecycleDependentImpactTitle', {
      defaultMessage: 'Retention changes for dependent streams'
    }),
    iconType: "logstashFilter"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.lifecycleDependentImpactDesc', {
    defaultMessage: 'Data retention changes will apply to dependant streams unless they already have custom retention settings in place.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), wiredStreamsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : inheritingStreams.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.inheritingChildStreams', {
    defaultMessage: 'The following child streams will be updated:'
  }), ' ', inheritingStreams.map(name => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(LinkToStream, {
    name: name
  }), ' ')), ".") : 'No child streams will be updated.'))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppModalFooterCancelButton",
    disabled: updateInProgress,
    color: "primary",
    onClick: () => closeModal()
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.cancelLifecycleUpdate', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppModalFooterButton",
    fill: true,
    disabled: confirmationIsDisabled,
    isLoading: updateInProgress,
    onClick: () => onConfirm()
  }, confirmationLabel))))));
}
function LinkToStream({
  name
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "streamsAppLinkToStreamLink",
    target: "_blank",
    href: router.link('/{key}/{tab}', {
      path: {
        key: name,
        tab: 'overview'
      }
    })
  }, "[", name, "]");
}