"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourcesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
var _translations = require("./translations");
var _add_data_sources_context_menu = require("./add_data_sources_context_menu");
var _data_source = require("./data_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataSourcesFlyout = ({
  onClose
}) => {
  const dataSourcesActorRefs = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => snapshot.context.dataSourcesRefs);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    onClose: onClose,
    size: "m",
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, _translations.DATA_SOURCES_I18N.flyout.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    color: "subdued"
  }, _translations.DATA_SOURCES_I18N.flyout.subtitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      title: _translations.DATA_SOURCES_I18N.flyout.infoDescription,
      iconType: "pin"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations.DATA_SOURCES_I18N.flyout.infoTitle)), /*#__PURE__*/_react.default.createElement(_add_data_sources_context_menu.AddDataSourcesContextMenu, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "ul",
    direction: "column",
    gutterSize: "m"
  }, dataSourcesActorRefs.map(dataSourceRef => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: dataSourceRef.id,
    component: "li"
  }, /*#__PURE__*/_react.default.createElement(_data_source.DataSource, {
    dataSourceRef: dataSourceRef
  }))))));
};
exports.DataSourcesFlyout = DataSourcesFlyout;