"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomSamplesDataSourceCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _streamsSchema = require("@kbn/streams-schema");
var _url_schema = require("../../../../../common/url_schema");
var _data_source_state_machine = require("../state_management/data_source_state_machine");
var _helpers = require("../helpers");
var _data_source_card = require("./data_source_card");
var _name_field = require("./name_field");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomSamplesDataSourceCard = ({
  dataSourceRef
}) => {
  const dataSource = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot.context.dataSource);
  const isDisabled = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot.matches('disabled'));
  const handleChange = params => {
    dataSourceRef.send({
      type: 'dataSource.change',
      dataSource: {
        ...dataSource,
        ...params
      }
    });
  };
  const editorValue = (0, _react.useMemo)(() => (0, _helpers.serializeXJson)(dataSource.documents, '[]'), [dataSource.documents]);
  const handleEditorChange = value => {
    const documents = (0, _helpers.deserializeJson)(value);
    if ((0, _streamsSchema.isSchema)(_url_schema.customSamplesDataSourceDocumentsSchema, documents)) {
      handleChange({
        documents
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_data_source_card.DataSourceCard, {
    dataSourceRef: dataSourceRef,
    title: _translations.DATA_SOURCES_I18N.customSamples.defaultName,
    subtitle: _translations.DATA_SOURCES_I18N.customSamples.subtitle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    size: "s",
    title: _translations.DATA_SOURCES_I18N.customSamples.callout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_name_field.NameField, {
    onChange: event => handleChange({
      name: event.target.value
    }),
    value: dataSource.name,
    disabled: isDisabled
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.DATA_SOURCES_I18N.customSamples.label,
    helpText: _translations.DATA_SOURCES_I18N.customSamples.helpText,
    isDisabled: isDisabled,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 200,
    value: editorValue,
    onChange: handleEditorChange,
    languageId: "xjson",
    options: {
      tabSize: 2,
      automaticLayout: true,
      readOnly: isDisabled
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.CustomSamplesDataSourceCard = CustomSamplesDataSourceCard;