"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFormType = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _ecs_recommendation = require("./ecs_recommendation");
var _field_type = require("../field_type");
var _use_kibana = require("../../../../hooks/use_kibana");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldFormType = ({
  field,
  isEditing,
  onTypeChange
}) => {
  var _fieldsMetadata$ecsFi;
  const {
    useFieldsMetadata
  } = (0, _use_kibana.useKibana)().dependencies.start.fieldsMetadata;
  const ecsFieldName = (0, _streamsSchema.getRegularEcsField)(field.name);
  const {
    fieldsMetadata,
    loading
  } = useFieldsMetadata({
    attributes: ['type'],
    fieldNames: [ecsFieldName]
  }, [field]);

  // Propagate recommendation to state if a type is not already set
  const recommendation = fieldsMetadata === null || fieldsMetadata === void 0 ? void 0 : (_fieldsMetadata$ecsFi = fieldsMetadata[ecsFieldName]) === null || _fieldsMetadata$ecsFi === void 0 ? void 0 : _fieldsMetadata$ecsFi.type;
  (0, _react.useEffect)(() => {
    if (!loading && recommendation !== undefined &&
    // Supported type
    recommendation in _constants.FIELD_TYPE_MAP && !field.type) {
      onTypeChange(recommendation);
    }
  }, [field, loading, recommendation, onTypeChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isEditing ? /*#__PURE__*/_react.default.createElement(FieldTypeSelector, {
    value: field.type,
    onChange: onTypeChange,
    isLoading: loading
  }) : field.type ? /*#__PURE__*/_react.default.createElement(_field_type.FieldType, {
    type: field.type
  }) : _constants.EMPTY_CONTENT), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ecs_recommendation.EcsRecommendation, {
    isLoading: loading,
    recommendation: recommendation
  })));
};
exports.FieldFormType = FieldFormType;
const typeSelectorOptions = Object.entries(_constants.FIELD_TYPE_MAP).filter(([_, {
  readonly
}]) => !readonly).map(([optionKey, {
  label
}]) => ({
  text: label,
  value: optionKey
}));
const FieldTypeSelector = ({
  value,
  onChange,
  isLoading = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    isLoading: isLoading,
    "data-test-subj": "streamsAppFieldFormTypeSelect",
    hasNoInitialSelection: !value,
    onChange: event => {
      onChange(event.target.value);
    },
    value: value,
    options: typeSelectorOptions
  });
};