"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRESTApiError = exports.isFieldInvalid = exports.isCORSError = exports.getSelectedConnectorIcon = exports.getConnectorDescriptiveTitle = exports.choicesToEuiOptions = exports.DEFAULT_CORRELATION_ID = exports.ACTION_GROUP_RECOVERED = void 0;
var _react = require("react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _cors_error = require("./cors_error");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_CORRELATION_ID = exports.DEFAULT_CORRELATION_ID = '{{rule.id}}:{{alert.id}}';
const ACTION_GROUP_RECOVERED = exports.ACTION_GROUP_RECOVERED = 'recovered';
const choicesToEuiOptions = choices => choices.map(choice => ({
  value: choice.value,
  text: choice.label
}));
exports.choicesToEuiOptions = choicesToEuiOptions;
const isRESTApiError = res => res != null && (res.error != null || res.status === 'failure');
exports.isRESTApiError = isRESTApiError;
const isCORSError = error => error instanceof _cors_error.CORSError;
exports.isCORSError = isCORSError;
const isFieldInvalid = (field, error) => error !== undefined && Number(error.length) > 0 && field !== undefined;
exports.isFieldInvalid = isFieldInvalid;
const getConnectorDescriptiveTitle = connector => {
  let title = connector.name;
  if (connector.isDeprecated) {
    title += ` ${_public.deprecatedMessage}`;
  }
  return title;
};
exports.getConnectorDescriptiveTitle = getConnectorDescriptiveTitle;
const getSelectedConnectorIcon = actionConnector => {
  if (actionConnector.isDeprecated) {
    return /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./selection_row'))));
  }
};
exports.getSelectedConnectorIcon = getSelectedConnectorIcon;