"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants2 = require("../../../common/inference/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceServiceParamsFields = ({
  actionParams,
  editAction,
  index,
  errors,
  actionConnector,
  messageVariables
}) => {
  const {
    subAction,
    subActionParams
  } = actionParams;
  const [isEndpointExists, setIsInferenceEndpointExists] = (0, _react.useState)(true);
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    taskType,
    provider,
    inferenceId
  } = actionConnector.config;
  (0, _react.useEffect)(() => {
    const f = async () => {
      setIsInferenceEndpointExists(await (0, _inferenceEndpointUiCommon.isInferenceEndpointExists)(http, inferenceId));
    };
    f();
  }, [http, inferenceId]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', taskType === 'chat_completion' ? _constants2.SUB_ACTION.UNIFIED_COMPLETION : taskType, index);
    }
  }, [editAction, index, provider, subAction, taskType]);
  (0, _react.useEffect)(() => {
    if (!subActionParams) {
      var _DEFAULTS_BY_TASK_TYP;
      editAction('subActionParams', {
        ...((_DEFAULTS_BY_TASK_TYP = _constants.DEFAULTS_BY_TASK_TYPE[taskType === 'chat_completion' ? _constants2.SUB_ACTION.UNIFIED_COMPLETION : taskType]) !== null && _DEFAULTS_BY_TASK_TYP !== void 0 ? _DEFAULTS_BY_TASK_TYP : {})
      }, index);
    }
  }, [editAction, index, provider, subActionParams, taskType]);
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  if (!isEndpointExists) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Missing configuration",
      color: "warning",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackConnectors.components.inference.loadingErrorText",
      defaultMessage: 'Inference Endpoint by ID {inferenceId} does not exist!',
      values: {
        inferenceId
      }
    }));
  }
  if (subAction === _constants2.SUB_ACTION.UNIFIED_COMPLETION) {
    return /*#__PURE__*/_react.default.createElement(UnifiedCompletionParamsFields, {
      errors: errors,
      messageVariables: messageVariables,
      editSubActionParams: editSubActionParams,
      subActionParams: subActionParams
    });
  }
  if (subAction === _constants2.SUB_ACTION.UNIFIED_COMPLETION_ASYNC_ITERATOR) {
    return /*#__PURE__*/_react.default.createElement(UnifiedCompletionParamsFields, {
      errors: errors,
      messageVariables: messageVariables,
      editSubActionParams: editSubActionParams,
      subActionParams: subActionParams
    });
  }
  if (subAction === _constants2.SUB_ACTION.COMPLETION) {
    return /*#__PURE__*/_react.default.createElement(CompletionParamsFields, {
      errors: errors,
      editSubActionParams: editSubActionParams,
      subActionParams: subActionParams
    });
  }
  if (subAction === _constants2.SUB_ACTION.RERANK) {
    return /*#__PURE__*/_react.default.createElement(RerankParamsFields, {
      errors: errors,
      editSubActionParams: editSubActionParams,
      subActionParams: subActionParams
    });
  }
  if (subAction === _constants2.SUB_ACTION.SPARSE_EMBEDDING) {
    return /*#__PURE__*/_react.default.createElement(SparseEmbeddingParamsFields, {
      errors: errors,
      editSubActionParams: editSubActionParams,
      subActionParams: subActionParams
    });
  }
  if (subAction === _constants2.SUB_ACTION.TEXT_EMBEDDING) {
    return /*#__PURE__*/_react.default.createElement(TextEmbeddingParamsFields, {
      errors: errors,
      editSubActionParams: editSubActionParams,
      subActionParams: subActionParams
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.default = InferenceServiceParamsFields;
const InferenceInput = ({
  input,
  inputError,
  editSubActionParams
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: inputError,
    isInvalid: false,
    label: i18n.INPUT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "inferenceInput",
    name: "input",
    value: input,
    onChange: e => {
      editSubActionParams({
        input: e.target.value
      });
    },
    isInvalid: false,
    fullWidth: true
  }));
};
const UnifiedCompletionParamsFields = ({
  subActionParams,
  editSubActionParams,
  errors,
  messageVariables
}) => {
  const {
    body
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: JSON.stringify(body),
    label: i18n.BODY,
    errors: errors.body,
    onDocumentsChange: json => {
      var _parsedJson;
      let parsedJson;
      try {
        parsedJson = JSON.parse(json);
      } catch (e) {
        // If the JSON is invalid, we keep the original string so it can go through validation
      }
      // Update with parsedJson, when valid, to ensure the body is sent as an object when action params are submitted
      editSubActionParams({
        body: (_parsedJson = parsedJson) !== null && _parsedJson !== void 0 ? _parsedJson : json
      });
    },
    onBlur: () => {
      if (!subActionParams.body) {
        editSubActionParams({
          body: {
            messages: []
          }
        });
      }
    },
    dataTestSubj: "inference-bodyJsonEditor"
  }));
};
const CompletionParamsFields = ({
  subActionParams,
  editSubActionParams,
  errors
}) => {
  const {
    input
  } = subActionParams;
  return /*#__PURE__*/_react.default.createElement(InferenceInput, {
    input: input,
    editSubActionParams: editSubActionParams,
    inputError: errors.input
  });
};
const SparseEmbeddingParamsFields = ({
  subActionParams,
  editSubActionParams,
  errors
}) => {
  const {
    input
  } = subActionParams;
  return /*#__PURE__*/_react.default.createElement(InferenceInput, {
    input: input,
    editSubActionParams: editSubActionParams,
    inputError: errors.input
  });
};
const TextEmbeddingParamsFields = ({
  subActionParams,
  editSubActionParams,
  errors
}) => {
  const {
    input,
    inputType
  } = subActionParams;
  const options = [{
    value: 'ingest',
    text: 'ingest'
  }, {
    value: 'search',
    text: 'search'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.inputType,
    isInvalid: false,
    label: i18n.INPUT_TYPE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "inferenceInputType",
    fullWidth: true,
    name: "inputType",
    isInvalid: false,
    options: options,
    value: inputType,
    onChange: e => {
      editSubActionParams({
        inputType: e.target.value
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(InferenceInput, {
    input: input,
    editSubActionParams: editSubActionParams,
    inputError: errors.input
  }));
};
const RerankParamsFields = ({
  subActionParams,
  editSubActionParams,
  errors
}) => {
  const {
    input,
    query
  } = subActionParams;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    paramsProperty: 'input',
    inputTargetValue: JSON.stringify(input),
    label: i18n.INPUT,
    errors: errors.input,
    onDocumentsChange: json => {
      editSubActionParams({
        input: json.trim()
      });
    },
    onBlur: () => {
      if (!input) {
        editSubActionParams({
          input: []
        });
      }
    },
    dataTestSubj: "inference-inputJsonEditor"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.input,
    isInvalid: false,
    label: i18n.QUERY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "inferenceQuery",
    name: "query",
    value: query,
    onChange: e => {
      editSubActionParams({
        query: e.target.value
      });
    },
    isInvalid: false,
    fullWidth: true
  })));
};

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;