"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("../../../../common/auth/constants");
var _validator = require("../validator");
var _action_variables = require("../action_variables");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const GetStep = ({
  display,
  readOnly
}) => {
  const [{
    config
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.getIncidentMethod']
  });
  const {
    getIncidentMethod = _constants.WebhookMethods.GET
  } = config !== null && config !== void 0 ? config : {};
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "getStep",
    style: {
      display: display ? 'block' : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, i18n.STEP_3), /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.STEP_3_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.getIncidentMethod",
    component: _components.Field,
    config: {
      label: i18n.GET_INCIDENT_METHOD,
      defaultValue: _constants.WebhookMethods.GET,
      type: _hook_form_lib.FIELD_TYPES.SELECT,
      validations: [{
        validator: emptyField(i18n.GET_METHOD_REQUIRED)
      }]
    },
    css: (0, _react2.css)`
                .euiFormRow__labelWrapper {
                  margin-bottom: 9px;
                }
              `,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'webhookGetIncidentMethodSelect',
        options: [_constants.WebhookMethods.GET, _constants.WebhookMethods.POST].map(verb => ({
          text: verb.toUpperCase(),
          value: verb
        })),
        readOnly
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.getIncidentUrl",
    config: {
      label: i18n.GET_INCIDENT_URL,
      validations: [{
        validator: urlField(i18n.GET_INCIDENT_URL_REQUIRED)
      }, {
        validator: (0, _validator.containsExternalIdForGet)(getIncidentMethod)
      }],
      helpText: i18n.GET_INCIDENT_URL_HELP
    },
    component: _public.MustacheTextFieldWrapper,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'webhookGetUrlText',
        messageVariables: _action_variables.urlVars,
        paramsProperty: 'getIncidentUrl',
        buttonTitle: i18n.ADD_CASES_VARIABLE,
        showButtonTitle: true
      }
    }
  }))), getIncidentMethod === _constants.WebhookMethods.POST ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.getIncidentJson",
    config: {
      helpText: i18n.GET_INCIDENT_JSON_HELP,
      label: i18n.GET_INCIDENT_JSON,
      validations: [{
        validator: (0, _validator.requiredJsonForPost)(getIncidentMethod)
      }]
    },
    component: _public.JsonFieldWrapper,
    componentProps: {
      euiCodeEditorProps: {
        height: '200px',
        isReadOnly: readOnly,
        ['aria-label']: i18n.CODE_EDITOR
      },
      dataTestSubj: 'webhookGetIncidentJson',
      messageVariables: _action_variables.urlVars,
      paramsProperty: 'getIncidentJson',
      buttonTitle: i18n.ADD_CASES_VARIABLE,
      showButtonTitle: true
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.getIncidentResponseExternalTitleKey",
    config: {
      label: i18n.GET_INCIDENT_TITLE_KEY,
      validations: [{
        validator: emptyField(i18n.GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED)
      }],
      helpText: i18n.GET_INCIDENT_TITLE_KEY_HELP
    },
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'getIncidentResponseExternalTitleKeyText'
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.viewIncidentUrl",
    config: {
      label: i18n.EXTERNAL_INCIDENT_VIEW_URL,
      validations: [{
        validator: urlField(i18n.GET_INCIDENT_VIEW_URL_REQUIRED)
      }, {
        validator: (0, _validator.containsExternalIdOrTitle)()
      }],
      helpText: i18n.EXTERNAL_INCIDENT_VIEW_URL_HELP
    },
    component: _public.MustacheTextFieldWrapper,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'viewIncidentUrlText',
        messageVariables: _action_variables.urlVarsExt,
        paramsProperty: 'viewIncidentUrl',
        buttonTitle: i18n.ADD_CASES_VARIABLE,
        showButtonTitle: true
      }
    }
  }))));
};
exports.GetStep = GetStep;