"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshotForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _validation = require("../../services/validation");
var _steps = require("./steps");
var _navigation = require("./navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RestoreSnapshotForm = ({
  snapshotDetails,
  isSaving,
  saveError,
  clearSaveError,
  onSave
}) => {
  // Step state
  const [currentStep, setCurrentStep] = (0, _react.useState)(1);
  const [maxCompletedStep, setMaxCompletedStep] = (0, _react.useState)(0);
  const stepMap = {
    1: _steps.RestoreSnapshotStepLogistics,
    2: _steps.RestoreSnapshotStepSettings,
    3: _steps.RestoreSnapshotStepReview
  };
  const CurrentStepForm = stepMap[currentStep];

  // Restore details state
  const [restoreSettings, setRestoreSettings] = (0, _react.useState)({
    // Since includeGlobalState always includes all featureStates when enabled,
    // we wanna keep in the local state that no feature states will be restored
    // by default.
    featureStates: [_constants.FEATURE_STATES_NONE_OPTION]
  });

  // Restore validation state
  const [validation, setValidation] = (0, _react.useState)({
    isValid: true,
    errors: {}
  });
  const updateRestoreSettings = updatedSettings => {
    const newRestoreSettings = {
      ...restoreSettings,
      ...updatedSettings
    };
    const newValidation = (0, _validation.validateRestore)(newRestoreSettings);
    setRestoreSettings(newRestoreSettings);
    setValidation(newValidation);
  };
  const updateCurrentStep = step => {
    if (maxCompletedStep < step - 1) {
      return;
    }
    setCurrentStep(step);
    setMaxCompletedStep(step - 1);
    clearSaveError();
  };
  const onBack = () => {
    const previousStep = currentStep - 1;
    setCurrentStep(previousStep);
    setMaxCompletedStep(previousStep - 1);
    clearSaveError();
  };
  const onNext = () => {
    if (!validation.isValid) {
      return;
    }
    const nextStep = currentStep + 1;
    setMaxCompletedStep(Math.max(currentStep, maxCompletedStep));
    setCurrentStep(nextStep);
  };
  const executeRestore = () => {
    if (validation.isValid) {
      onSave(restoreSettings);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_navigation.RestoreSnapshotNavigation, {
    currentStep: currentStep,
    maxCompletedStep: maxCompletedStep,
    updateCurrentStep: updateCurrentStep
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "restoreSnapshotsForm"
  }, /*#__PURE__*/_react.default.createElement(CurrentStepForm, {
    snapshotDetails: snapshotDetails,
    restoreSettings: restoreSettings,
    updateRestoreSettings: updateRestoreSettings,
    errors: validation.errors,
    updateCurrentStep: updateCurrentStep
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), saveError ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, saveError, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, currentStep > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    onClick: () => onBack(),
    disabled: !validation.isValid,
    "data-test-subj": "backButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.backButtonLabel",
    defaultMessage: "Back"
  }))) : null, currentStep < 3 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "arrowRight",
    onClick: () => onNext(),
    disabled: !validation.isValid,
    "data-test-subj": "nextButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.nextButtonLabel",
    defaultMessage: "Next"
  }))) : null, currentStep === 3 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "success",
    iconType: "check",
    onClick: () => executeRestore(),
    isLoading: isSaving,
    "data-test-subj": "restoreButton"
  }, isSaving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.savingButtonLabel",
    defaultMessage: "Restoring\u2026"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.submitButtonLabel",
    defaultMessage: "Restore snapshot"
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.RestoreSnapshotForm = RestoreSnapshotForm;