"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetSLORoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _reset_slo = require("../../services/reset_slo");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resetSLORoute = exports.resetSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/{id}/_reset 2023-10-31',
  options: {
    access: 'public'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: _sloSchema.resetSLOParamsSchema,
  handler: async ({
    params,
    logger,
    request,
    plugins,
    corePlugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient,
      spaceId,
      repository,
      transformManager,
      summaryTransformManager
    } = await getScopedClients({
      request,
      logger
    });
    const basePath = corePlugins.http.basePath;
    const resetSLO = new _reset_slo.ResetSLO(scopedClusterClient, repository, transformManager, summaryTransformManager, logger, spaceId, basePath);
    return await resetSLO.execute(params.path.id);
  }
});