"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useParseUrlState = useParseUrlState;
var _public = require("@kbn/kibana-utils-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _process_slo_form_values = require("../helpers/process_slo_form_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useParseUrlState() {
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useMemo)(() => {
    const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
      history,
      useHash: false,
      useHashQuery: false
    });
    const urlState = urlStateStorage.get('_a');
    return !!urlState ? (0, _process_slo_form_values.transformPartialSLOStateToFormState)(urlState) : undefined;
  }, [history]);
}