"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBurnRateRuleRequestBody = createBurnRateRuleRequestBody;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../components/burn_rate_rule_editor/constants");
var _windows = require("../../../components/burn_rate_rule_editor/windows");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createBurnRateWindowsFromSLO(slo) {
  const burnRateDefaults = slo ? _constants.BURN_RATE_DEFAULTS[slo === null || slo === void 0 ? void 0 : slo.timeWindow.duration] : _constants.BURN_RATE_DEFAULTS['30d'];
  return burnRateDefaults.map(partialWindow => (0, _windows.createNewWindow)(slo, partialWindow));
}
function createBurnRateRuleRequestBody(slo) {
  return {
    params: {
      sloId: slo.id,
      windows: createBurnRateWindowsFromSLO(slo)
    },
    consumer: 'slo',
    schedule: {
      interval: '1m'
    },
    tags: [],
    name: _i18n.i18n.translate('xpack.slo.burnRateRule.name', {
      defaultMessage: '{name} Burn Rate rule',
      values: {
        name: slo.name
      }
    }),
    rule_type_id: 'slo.rules.burnRate',
    actions: [],
    enabled: true
  };
}