"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloActions = void 0;
var _public = require("@kbn/observability-plugin/public");
var _path = _interopRequireDefault(require("path"));
var _paths = require("../../../../common/locators/paths");
var _use_space = require("../../../hooks/use_space");
var _use_kibana = require("../../../hooks/use_kibana");
var _remote_slo_urls = require("../../../utils/slo/remote_slo_urls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSloActions = ({
  slo,
  rules,
  setIsEditRuleFlyoutOpen,
  setIsActionsPopoverOpen
}) => {
  var _slo$remote;
  const {
    share: {
      url: {
        locators
      }
    },
    http
  } = (0, _use_kibana.useKibana)().services;
  const spaceId = (0, _use_space.useSpace)();
  if (!slo) {
    return {
      sloEditUrl: '',
      handleNavigateToRules: () => {},
      remoteDeleteUrl: undefined,
      remoteResetUrl: undefined,
      remoteEnableUrl: undefined,
      remoteDisableUrl: undefined,
      sloDetailsUrl: ''
    };
  }
  const handleNavigateToRules = async () => {
    if ((rules === null || rules === void 0 ? void 0 : rules.length) === 1) {
      // if there is only one rule we can edit inline in flyout
      setIsEditRuleFlyoutOpen(true);
      setIsActionsPopoverOpen(false);
    } else {
      const locator = locators.get(_public.rulesLocatorID);
      if (!locator) return undefined;
      if (slo.remote && slo.remote.kibanaUrl !== '') {
        const basePath = http.basePath.get(); // "/kibana/s/my-space"
        const url = await locator.getUrl({
          params: {
            sloId: slo.id
          }
        }); // "/kibana/s/my-space/app/rules/123"
        // since basePath is already included in the locatorUrl, we need to remove it from the start of url
        const urlWithoutBasePath = url === null || url === void 0 ? void 0 : url.replace(basePath, ''); // "/app/rules/123"
        const spacePath = spaceId !== 'default' ? `/s/${spaceId}` : '';
        const remoteUrl = new URL(_path.default.join(spacePath, urlWithoutBasePath), slo.remote.kibanaUrl); // "kibanaUrl/s/my-space/app/rules/123"
        window.open(remoteUrl, '_blank');
      } else {
        locator.navigate({
          params: {
            sloId: slo.id
          }
        }, {
          replace: false
        });
      }
    }
  };
  const detailsUrl = _paths.paths.sloDetails(slo.id, slo.instanceId, (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName);
  const remoteDeleteUrl = (0, _remote_slo_urls.createRemoteSloDeleteUrl)(slo, spaceId);
  const remoteResetUrl = (0, _remote_slo_urls.createRemoteSloResetUrl)(slo, spaceId);
  const remoteEnableUrl = (0, _remote_slo_urls.createRemoteSloEnableUrl)(slo, spaceId);
  const remoteDisableUrl = (0, _remote_slo_urls.createRemoteSloDisableUrl)(slo, spaceId);
  const sloEditUrl = slo.remote ? (0, _remote_slo_urls.createRemoteSloEditUrl)(slo, spaceId) : http.basePath.prepend(_paths.paths.sloEdit(slo.id));
  return {
    sloEditUrl,
    handleNavigateToRules,
    remoteDeleteUrl,
    remoteResetUrl,
    remoteEnableUrl,
    remoteDisableUrl,
    sloDetailsUrl: http.basePath.prepend(detailsUrl)
  };
};
exports.useSloActions = useSloActions;