"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloHealthStateText = getSloHealthStateText;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSloHealthStateText(hasUnhealthy, hasMissing) {
  if (hasUnhealthy && hasMissing) {
    return _i18n.i18n.translate('xpack.slo.sloHealth.unhealthyOrMissingState', {
      defaultMessage: 'an unhealthy or missing'
    });
  } else if (hasUnhealthy) {
    return _i18n.i18n.translate('xpack.slo.sloHealth.unhealthyState', {
      defaultMessage: 'an unhealthy'
    });
  } else {
    return _i18n.i18n.translate('xpack.slo.sloHealth.missingState', {
      defaultMessage: 'a missing'
    });
  }
}