"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listUsersRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _list = require("../../../../../../common/api/entity_analytics/privilege_monitoring/users/list.gen");
var _constants = require("../../../../../../common/constants");
var _assert_advanced_setting_enabled = require("../../../utils/assert_advanced_setting_enabled");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listUsersRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: '/api/entity_analytics/monitoring/users/list',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: _list.ListPrivMonUsersRequestQuery
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
      const secSol = await context.securitySolution;
      const body = await secSol.getPrivilegeMonitoringDataClient().listUsers(request.query.kql);
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error listing users: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.listUsersRoute = listUsersRoute;