"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPrivilegeMonitoringRoutes = void 0;
var _create_index = require("./create_index");
var _health = require("./health");
var _init = require("./init");
var _monitoring_entity_source = require("./monitoring_entity_source");
var _search_indices = require("./search_indices");
var _users = require("./users");
var _pad_install = require("./privileged_access_detection/pad_install");
var _pad_get_installation_status = require("./privileged_access_detection/pad_get_installation_status");
var _disable = require("./disable");
var _privileges = require("./privileges");
var _delete = require("./delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerPrivilegeMonitoringRoutes = ({
  router,
  logger,
  config,
  getStartServices
}) => {
  (0, _pad_install.padInstallRoute)(router, logger, config);
  (0, _pad_get_installation_status.padGetStatusRoute)(router, logger, config);
  (0, _init.initPrivilegeMonitoringEngineRoute)(router, logger, config);
  (0, _delete.deletePrivilegeMonitoringEngineRoute)(router, logger, config);
  (0, _health.healthCheckPrivilegeMonitoringRoute)(router, logger, config);
  (0, _privileges.privilegesCheckPrivilegeMonitoringRoute)(router, logger, getStartServices);
  (0, _search_indices.searchPrivilegeMonitoringIndicesRoute)(router, logger);
  (0, _create_index.createPrivilegeMonitoringIndicesRoute)(router, logger);
  (0, _monitoring_entity_source.monitoringEntitySourceRoute)(router, logger, config);
  (0, _monitoring_entity_source.listMonitoringEntitySourceRoute)(router, logger, config);
  (0, _users.createUserRoute)(router, logger);
  (0, _users.deleteUserRoute)(router, logger);
  (0, _users.listUsersRoute)(router, logger);
  (0, _users.updateUserRoute)(router, logger);
  (0, _users.uploadUsersCSVRoute)(router, logger, config);
  (0, _disable.disablePrivilegeMonitoringEngineRoute)(router, logger, config);
};
exports.registerPrivilegeMonitoringRoutes = registerPrivilegeMonitoringRoutes;