"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerWorkflowInsightsRoutes = void 0;
var _update_insight = require("./update_insight");
var _get_insights = require("./get_insights");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerWorkflowInsightsRoutes = (router, config, endpointContext) => {
  if (config.experimentalFeatures.defendInsights) {
    (0, _get_insights.registerGetInsightsRoute)(router, endpointContext);
    (0, _update_insight.registerUpdateInsightsRoute)(router, endpointContext);
  }
};
exports.registerWorkflowInsightsRoutes = registerWorkflowInsightsRoutes;