"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdateStatus = ({
  isUpdating,
  updatedAt
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued",
  "data-test-subj": "updateStatus"
}, isUpdating ? _translations.UPDATING : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.UPDATED, "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
  value: new Date(updatedAt)
})))));
exports.UpdateStatus = UpdateStatus;