"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TranslationCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCallOutInfo = mode => {
  switch (mode) {
    case 'mapped':
      return {
        title: i18n.CALLOUT_MAPPED_TRANSLATED_RULE_TITLE,
        icon: 'checkInCircleFilled',
        color: 'success'
      };
    case 'full':
      return {
        title: i18n.CALLOUT_TRANSLATED_RULE_TITLE,
        icon: 'checkInCircleFilled',
        color: 'success'
      };
    case 'partial':
      return {
        title: i18n.CALLOUT_PARTIALLY_TRANSLATED_RULE_TITLE,
        message: i18n.CALLOUT_PARTIALLY_TRANSLATED_RULE_DESCRIPTION,
        icon: 'warningFilled',
        color: 'warning'
      };
    case 'untranslatable':
      return {
        title: i18n.CALLOUT_NOT_TRANSLATED_RULE_TITLE,
        message: i18n.CALLOUT_NOT_TRANSLATED_RULE_DESCRIPTION,
        icon: 'checkInCircleFilled',
        color: 'danger'
      };
  }
};
const TranslationCallOut = exports.TranslationCallOut = /*#__PURE__*/_react.default.memo(({
  migrationRule
}) => {
  var _migrationRule$elasti;
  if (!migrationRule.translation_result) {
    return null;
  }
  const mode = (_migrationRule$elasti = migrationRule.elastic_rule) !== null && _migrationRule$elasti !== void 0 && _migrationRule$elasti.prebuilt_rule_id ? 'mapped' : migrationRule.translation_result;
  const {
    title,
    message,
    icon,
    color
  } = getCallOutInfo(mode);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: color,
    title: title,
    iconType: icon,
    size: 's',
    "data-test-subj": `ruleMigrationCallOut-${mode}`
  }, message);
});
TranslationCallOut.displayName = 'TranslationCallOut';