"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsavedChangesConfirmModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnsavedChangesConfirmModal = exports.UnsavedChangesConfirmModal = /*#__PURE__*/_react.default.memo(({
  onCancel,
  onConfirm
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    "data-test-subj": "policyDetailsUnsavedChangesModal",
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.unsavedChanges.title', {
      defaultMessage: 'Unsaved changes'
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.unsavedChanges.confirmButtonTitle', {
      defaultMessage: 'Continue without saving'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.unsavedChanges.cancelButtonTitle', {
      defaultMessage: 'Back'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.unsavedChanges.warningMessage",
    defaultMessage: "You have unsaved changes on this page. If you leave without saving, your changes will be lost."
  }));
});
UnsavedChangesConfirmModal.displayName = 'UnsavedChangesConfirmModal';