"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionViewNoDataMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Message displayed when the user does not have access to Session View
 */
const SessionViewNoDataMessage = ({
  isEnterprisePlus,
  hasSessionViewConfig
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return !isEnterprisePlus ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.SESSION_VIEW_UPSELL_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: 'xpack.securitySolution.flyout.sessionViewer.upsellDescription',
    defaultMessage: "This feature requires an {subscription}",
    values: {
      subscription: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/pricing/",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: 'xpack.securitySolution.flyout.sessionViewer.upsellLinkText',
        defaultMessage: "Enterprise subscription"
      }))
    }
  })) : !hasSessionViewConfig ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.SESSION_VIEW_NO_DATA_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: 'xpack.securitySolution.flyout.sessionViewer.noDataDescription',
    defaultMessage: "You can only view Linux session details if you\u2019ve enabled the {setting} setting in your Elastic Defend integration policy. Refer to {link} for more information.",
    values: {
      setting: /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _css.css)`
                font-weight: ${euiTheme.font.weight.bold};
              `
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: 'xpack.securitySolution.flyout.sessionViewer.noDataSettingDescription',
        defaultMessage: "Include session data"
      })),
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/session-view.html#enable-session-view",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: 'xpack.securitySolution.flyout.sessionViewer.noDataLinkText',
        defaultMessage: "Enable Session View data"
      }))
    }
  })) : null;
};
exports.SessionViewNoDataMessage = SessionViewNoDataMessage;
SessionViewNoDataMessage.displayName = 'SessionViewNoDataMessage';