"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProcessData = exports.getUserDisplayName = void 0;
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _utils = require("../../shared/utils");
var _context = require("../../shared/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_USER_NAME = 'process.entry_leader.user.name';
const FIELD_USER_ID = 'process.entry_leader.user.id';
const FIELD_PROCESS_NAME = 'process.entry_leader.name';
const FIELD_START_AT = 'process.entry_leader.start';
const FIELD_WORKING_DIRECTORY = 'process.group_leader.working_directory';
const FIELD_COMMAND = 'process.command_line';

/**
 * Returns user name with some fallback logic in case it is not available. The idea was borrowed from session viewer
 */
const getUserDisplayName = getFieldsData => {
  const userName = (0, _utils.getField)(getFieldsData(FIELD_USER_NAME));
  const userId = (0, _utils.getField)(getFieldsData(FIELD_USER_ID));
  if (userName) {
    return userName;
  }
  if (!userId) {
    return 'unknown';
  }
  return userId === '0' ? 'root' : `uid: ${userId}`;
};

/**
 * Returns memoized process-related values for the session preview component
 */
exports.getUserDisplayName = getUserDisplayName;
const useProcessData = () => {
  const {
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  return (0, _react.useMemo)(() => ({
    userName: getUserDisplayName(getFieldsData),
    processName: (0, _utils.getField)(getFieldsData(FIELD_PROCESS_NAME)),
    startAt: (0, _utils.getField)(getFieldsData(FIELD_START_AT)),
    ruleName: (0, _utils.getField)(getFieldsData(_ruleDataUtils.ALERT_RULE_NAME)),
    ruleId: (0, _utils.getField)(getFieldsData(_ruleDataUtils.ALERT_RULE_UUID)),
    workdir: (0, _utils.getField)(getFieldsData(FIELD_WORKING_DIRECTORY)),
    command: (0, _utils.getField)(getFieldsData(FIELD_COMMAND))
  }), [getFieldsData]);
};
exports.useProcessData = useProcessData;