"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardTableQuery = exports.DASHBOARD_TABLE_QUERY_ID = void 0;
var _esqlUtils = require("@kbn/esql-utils");
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _use_esql_global_filter = require("../../../../../common/hooks/esql/use_esql_global_filter");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _manage_query = require("../../../../../common/components/page/manage_query");
var _esql = require("../../../../../common/utils/esql");
var _kibana = require("../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DASHBOARD_TABLE_QUERY_ID = exports.DASHBOARD_TABLE_QUERY_ID = 'privmonDashboardTableQueryId';
const useDashboardTableQuery = tableQuery => {
  const filterQuery = (0, _use_esql_global_filter.useEsqlGlobalFilterQuery)();
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isRefetching,
    refetch,
    data: result,
    error
  } = (0, _reactQuery.useQuery)([tableQuery, filterQuery], async ({
    signal
  }) => (0, _esqlUtils.getESQLResults)({
    esqlQuery: tableQuery,
    search: data.search.search,
    signal,
    filter: filterQuery
  }), {
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const index = (0, _esqlUtils.getIndexPatternFromESQLQuery)(tableQuery);
  const response = result === null || result === void 0 ? void 0 : result.response;
  const inspect = (0, _react.useMemo)(() => {
    var _ref;
    return {
      dsl: [JSON.stringify({
        index: (_ref = [index]) !== null && _ref !== void 0 ? _ref : [''],
        body: (0, _esqlUtils.prettifyQuery)(tableQuery, false)
      }, null, 2)],
      response: response ? [JSON.stringify(response, null, 2)] : []
    };
  }, [tableQuery, response, index]);
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId: DASHBOARD_TABLE_QUERY_ID,
    loading: isLoading
  });
  const records = (0, _esql.esqlResponseToRecords)(response);
  return {
    records,
    isLoading,
    refetch,
    inspect,
    isError,
    error,
    isInitialLoading,
    isRefetching
  };
};
exports.useDashboardTableQuery = useDashboardTableQuery;