"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableRiskScore = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _header_section = require("../../../common/components/header_section");
var i18n = _interopRequireWildcard(require("./translations"));
var _entity_analytics_learn_more_link = require("../entity_analytics_learn_more_link");
var _risk_score_header_title = require("../risk_score_header_title");
var _links = require("../../../common/components/links");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnableRiskScoreComponent = ({
  isDisabled,
  entityType
}) => {
  if (!isDisabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      riskScoreEntity: entityType
    }),
    titleSize: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.ENABLE_RISK_SCORE(entityType)),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ENABLE_RISK_SCORE_DESCRIPTION(entityType), ` `, /*#__PURE__*/_react.default.createElement(_entity_analytics_learn_more_link.EntityAnalyticsLearnMoreLink, null)),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.ENABLE_RISK_SCORE_POPOVER
    }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
      color: "primary",
      fill: true,
      deepLinkId: _constants.SecurityPageName.entityAnalyticsManagement,
      "data-test-subj": `enable_risk_score`
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.enableButtonTitle",
      defaultMessage: "Enable"
    })))
  }));
};
const EnableRiskScore = exports.EnableRiskScore = /*#__PURE__*/_react.default.memo(EnableRiskScoreComponent);
EnableRiskScore.displayName = 'EnableRiskScore';