"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryEditAdapter = EqlQueryEditAdapter;
var _react = _interopRequireDefault(require("react"));
var _eql_query_edit = require("../../../../../../../rule_creation/components/eql_query_edit");
var _use_diffable_rule_data_view = require("../hooks/use_diffable_rule_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EqlQueryEditAdapter({
  finalDiffableRule
}) {
  const {
    dataView,
    isLoading
  } = (0, _use_diffable_rule_data_view.useDiffableRuleDataView)(finalDiffableRule);

  // Wait for dataView to be defined to trigger validation with the correct index patterns
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eql_query_edit.EqlQueryEdit, {
    path: "eqlQuery",
    eqlOptionsPath: "eqlOptions",
    required: true,
    dataView: dataView !== null && dataView !== void 0 ? dataView : DEFAULT_DATA_VIEW_BASE,
    loading: isLoading,
    disabled: isLoading
  });
}
const DEFAULT_DATA_VIEW_BASE = {
  title: '',
  fields: []
};