"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedPlayground = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("../../../common");
var _use_kibana = require("../../hooks/use_kibana");
var _use_llms_models = require("../../hooks/use_llms_models");
var _use_load_connectors = require("../../hooks/use_load_connectors");
var _use_playground_breadcrumbs = require("../../hooks/use_playground_breadcrumbs");
var _use_saved_playground_parameters = require("../../hooks/use_saved_playground_parameters");
var _use_show_setup_page = require("../../hooks/use_show_setup_page");
var _types = require("../../types");
var _header = require("../header");
var _routes = require("../../routes");
var _chat = require("../chat");
var _chat_setup_page = require("../setup_page/chat_setup_page");
var _search_mode = require("../search_mode/search_mode");
var _search_query_mode = require("../query_mode/search_query_mode");
var _saved_playground_fetch_error = require("./saved_playground_fetch_error");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedPlayground = () => {
  const models = (0, _use_llms_models.useLLMsModels)();
  const {
    playgroundId,
    pageMode,
    viewMode
  } = (0, _use_saved_playground_parameters.useSavedPlaygroundParameters)();
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: connectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  // TODO: need to handle errors from Form (loading errors, indices no longer exist etc.)
  const {
    formState,
    watch,
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const playgroundName = watch(_types.SavedPlaygroundFormFields.name);
  const playgroundIndices = watch(_types.SavedPlaygroundFormFields.indices);
  const summarizationModel = watch(_types.SavedPlaygroundFormFields.summarizationModel);
  (0, _use_playground_breadcrumbs.usePlaygroundBreadcrumbs)(playgroundName);
  const {
    showSetupPage
  } = (0, _use_show_setup_page.useShowSetupPage)({
    hasSelectedIndices: true,
    // Saved Playgrounds always have indices ? (at least to be saved)
    hasConnectors: Boolean(connectors === null || connectors === void 0 ? void 0 : connectors.length)
  });
  const navigateToView = (0, _react.useCallback)((page, view, searchParams) => {
    let path = `/p/${playgroundId}/${page}`;
    if (view && view !== _types.PlaygroundViewMode.preview) {
      path += `/${view}`;
    }
    if (searchParams) {
      path += searchParams;
    }
    application.navigateToApp(_common.PLUGIN_ID, {
      path
    });
  }, [application, playgroundId]);
  (0, _react.useEffect)(() => {
    if (formState.isLoading) return;
    if (pageMode === undefined) {
      // If there is not a pageMode set we redirect based on if there is a model set in the
      // saved playground as a best guess for default mode. until we save mode with the playground
      navigateToView(summarizationModel !== undefined ? _types.PlaygroundPageMode.Chat : _types.PlaygroundPageMode.Search, _types.PlaygroundViewMode.preview);
      return;
    }
    // Handle Unknown modes
    if (!Object.values(_types.PlaygroundPageMode).includes(pageMode)) {
      navigateToView(summarizationModel !== undefined ? _types.PlaygroundPageMode.Chat : _types.PlaygroundPageMode.Search, _types.PlaygroundViewMode.preview);
      return;
    }
    if (!Object.values(_types.PlaygroundViewMode).includes(viewMode)) {
      navigateToView(pageMode, _types.PlaygroundViewMode.preview);
    }
  }, [pageMode, viewMode, summarizationModel, formState.isLoading, navigateToView]);
  (0, _react.useEffect)(() => {
    // When opening chat mode without a model selected try to select a default model
    // if one is available.
    if (formState.isLoading) return;
    if (pageMode === _types.PlaygroundPageMode.Chat && summarizationModel === undefined && models.length > 0) {
      const defaultModel = models.find(model => !model.disabled);
      if (defaultModel) {
        setValue(_types.SavedPlaygroundFormFields.summarizationModel, defaultModel);
      }
    }
  }, [formState.isLoading, pageMode, summarizationModel, models, setValue]);
  const handleModeChange = id => navigateToView(pageMode !== null && pageMode !== void 0 ? pageMode : _types.PlaygroundPageMode.Search, id, location.search);
  const handlePageModeChange = mode => navigateToView(mode, viewMode, location.search);
  const {
    isLoading
  } = formState;
  if (isLoading || pageMode === undefined) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)));
  }
  if (playgroundName.length === 0 && playgroundIndices.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_saved_playground_fetch_error.SavedPlaygroundFetchError, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
    playgroundName: playgroundName,
    hasChanges: false,
    pageMode: pageMode,
    viewMode: viewMode,
    showDocs: false,
    onModeChange: handleModeChange,
    isActionsDisabled: false,
    onSelectPageModeChange: handlePageModeChange
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, showSetupPage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SAVED_PLAYGROUND_CHAT_PATH,
    component: _chat_setup_page.ChatSetupPage
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SAVED_PLAYGROUND_CHAT_PATH,
    component: _chat.Chat
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SAVED_PLAYGROUND_CHAT_QUERY_PATH,
    render: () => /*#__PURE__*/_react.default.createElement(_search_query_mode.SearchQueryMode, {
      pageMode: pageMode
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SAVED_PLAYGROUND_SEARCH_PATH,
    component: _search_mode.SearchMode
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SAVED_PLAYGROUND_SEARCH_QUERY_PATH,
    render: () => /*#__PURE__*/_react.default.createElement(_search_query_mode.SearchQueryMode, {
      pageMode: pageMode
    })
  }))));
};
exports.SavedPlayground = SavedPlayground;