"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuerySidePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _searchQueries = require("@kbn/search-queries");
var _reactHookForm = require("react-hook-form");
var _use_source_indices_field = require("../../hooks/use_source_indices_field");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _constants = require("../../analytics/constants");
var _search_query = require("./search_query");
var _query_fields_panel = require("./query_fields_panel");
var _chat_prompt = require("./chat_prompt");
var _edit_context_panel = require("../edit_context/edit_context_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QuerySidePanel = ({
  pageMode,
  executeQuery,
  executeQueryDisabled,
  isLoading
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    fields
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const sourceFields = (0, _reactHookForm.useWatch)({
    name: _types.PlaygroundFormFields.sourceFields
  });
  const {
    field: {
      onChange: queryFieldsOnChange,
      value: queryFields
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.queryFields
  });
  const {
    field: {
      onChange: elasticsearchQueryChange
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.elasticsearchQuery
  });
  const {
    field: {
      value: userElasticsearchQuery,
      onChange: userElasticsearchQueryChange
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.userElasticsearchQuery
  });
  const handleSearch = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (executeQueryDisabled) return;
    executeQuery();
  }, [executeQuery, executeQueryDisabled]);
  const updateFields = (0, _react.useCallback)((index, fieldName, checked) => {
    const currentIndexFields = checked ? [...queryFields[index], fieldName] : queryFields[index].filter(field => fieldName !== field);
    const updatedQueryFields = {
      ...queryFields,
      [index]: currentIndexFields
    };
    queryFieldsOnChange(updatedQueryFields);
    const updatedQuery = (0, _searchQueries.generateSearchQuery)(updatedQueryFields, sourceFields, fields);
    elasticsearchQueryChange(updatedQuery);
    // ensure the userQuery is cleared so it doesn't diverge from the generated query.
    userElasticsearchQueryChange(null);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.queryFieldsUpdated, currentIndexFields.length);
  }, [elasticsearchQueryChange, userElasticsearchQueryChange, fields, queryFields, queryFieldsOnChange, sourceFields, usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, pageMode === _types.PlaygroundPageMode.Search ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.sideBar.query.title",
    defaultMessage: "Query"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.sideBar.prompt.title",
    defaultMessage: "Question"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: handleSearch
  }, pageMode === _types.PlaygroundPageMode.Search ? /*#__PURE__*/_react.default.createElement(_search_query.SearchQuery, {
    isLoading: isLoading
  }) : /*#__PURE__*/_react.default.createElement(_chat_prompt.ChatPrompt, {
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.table.title",
    defaultMessage: "Fields to search (per index)"
  }))), Object.entries(fields).map(([index, group]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index
  }, /*#__PURE__*/_react.default.createElement(_query_fields_panel.QueryFieldsPanel, {
    index: index,
    indexFields: group,
    updateFields: updateFields,
    queryFields: queryFields,
    customizedQuery: userElasticsearchQuery !== null
  }))), pageMode === _types.PlaygroundPageMode.Chat && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.sideBar.context.title",
    defaultMessage: "Context"
  }))), /*#__PURE__*/_react.default.createElement(_edit_context_panel.EditContextPanel, null))));
};
exports.QuerySidePanel = QuerySidePanel;