"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_delete_endpoint = require("../../../../../../hooks/use_delete_endpoint");
var _confirm_delete_endpoint = require("./confirm_delete_endpoint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteAction = ({
  selectedEndpoint,
  onCancel,
  displayModal
}) => {
  const {
    mutate: deleteEndpoint
  } = (0, _use_delete_endpoint.useDeleteEndpoint)(onCancel);
  const onConfirmDeletion = () => {
    if (!selectedEndpoint) {
      return;
    }
    deleteEndpoint({
      type: selectedEndpoint.task_type,
      id: selectedEndpoint.inference_id
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, displayModal ? /*#__PURE__*/_react.default.createElement(_confirm_delete_endpoint.ConfirmDeleteEndpointModal, {
    onCancel: onCancel,
    onConfirm: onConfirmDeletion,
    inferenceEndpoint: selectedEndpoint
  }) : null);
};
exports.DeleteAction = DeleteAction;