"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _lib = require("../lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let allowedObjectTypes;
const title = _i18n.i18n.translate('savedObjectsManagement.objects.savedObjectsTitle', {
  defaultMessage: 'Saved Objects'
});
const SavedObjectsEditionPage = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./saved_objects_edition_page'))));
const SavedObjectsTablePage = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./saved_objects_table_page'))));
const mountManagementSection = async ({
  core,
  mountParams,
  getColumnServiceStart,
  getActionServiceStart
}) => {
  const [coreStart, {
    data,
    dataViews,
    savedObjectsTaggingOss,
    spaces: spacesApi
  }] = await core.getStartServices();
  const {
    capabilities
  } = coreStart.application;
  const {
    element,
    history,
    setBreadcrumbs
  } = mountParams;
  if (!allowedObjectTypes) {
    allowedObjectTypes = await (0, _lib.getAllowedTypes)(coreStart.http);
  }
  coreStart.chrome.docTitle.change(title);
  const RedirectToHomeIfUnauthorized = ({
    children
  }) => {
    var _capabilities$managem, _capabilities$managem2, _capabilities$managem3;
    const allowed = (_capabilities$managem = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$managem2 = capabilities.management) === null || _capabilities$managem2 === void 0 ? void 0 : (_capabilities$managem3 = _capabilities$managem2.kibana) === null || _capabilities$managem3 === void 0 ? void 0 : _capabilities$managem3.objects) !== null && _capabilities$managem !== void 0 ? _capabilities$managem : false;
    if (!allowed) {
      coreStart.application.navigateToApp('home');
      return null;
    }
    return children;
  };
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/:type/:id',
    exact: true
  }, /*#__PURE__*/_react.default.createElement(RedirectToHomeIfUnauthorized, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(SavedObjectsEditionPage, {
    coreStart: coreStart,
    setBreadcrumbs: setBreadcrumbs,
    history: history
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/',
    exact: false
  }, /*#__PURE__*/_react.default.createElement(RedirectToHomeIfUnauthorized, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(SavedObjectsTablePage, {
    coreStart: coreStart,
    taggingApi: savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi(),
    spacesApi: spacesApi,
    dataStart: data,
    dataViewsApi: dataViews,
    actionRegistry: getActionServiceStart(),
    columnRegistry: getColumnServiceStart(),
    allowedTypes: allowedObjectTypes,
    setBreadcrumbs: setBreadcrumbs
  }))))))), element);
  return () => {
    coreStart.chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountManagementSection = mountManagementSection;