"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultAlertExecutorOptions = void 0;
var _mocks = require("@kbn/core/server/mocks");
var _mocks2 = require("@kbn/alerting-plugin/server/mocks");
var _mocks3 = require("@kbn/data-plugin/common/search/search_source/mocks");
var _mocks4 = require("@kbn/data-views-plugin/public/mocks");
var _rules_settings = require("@kbn/alerting-plugin/common/rules_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDefaultAlertExecutorOptions = ({
  alertId = 'ALERT_INSTANCE_ID',
  ruleName = 'ALERT_RULE_NAME',
  params,
  state,
  logger,
  createdAt = new Date(),
  startedAt = new Date(),
  updatedAt = new Date(),
  shouldWriteAlerts = true
}) => ({
  startedAt,
  startedAtOverridden: false,
  rule: {
    id: alertId,
    updatedBy: null,
    tags: ['rule-tag1', 'rule-tag2'],
    name: ruleName,
    createdBy: 'CREATED_BY',
    actions: [],
    enabled: true,
    consumer: 'CONSUMER',
    producer: 'ALERT_PRODUCER',
    schedule: {
      interval: '1m'
    },
    throttle: null,
    createdAt,
    updatedAt,
    notifyWhen: null,
    revision: 0,
    ruleTypeId: 'RULE_TYPE_ID',
    ruleTypeName: 'RULE_TYPE_NAME',
    muteAll: false,
    snoozeSchedule: []
  },
  params,
  spaceId: 'SPACE_ID',
  services: {
    alertFactory: _mocks2.alertsMock.createRuleExecutorServices().alertFactory,
    alertsClient: null,
    getDataViews: async () => _mocks4.dataViewPluginMocks.createStartContract(),
    getMaintenanceWindowIds: async () => ['test-id-1', 'test-id-2'],
    getSearchSourceClient: async () => _mocks3.searchSourceCommonMock,
    savedObjectsClient: _mocks.savedObjectsClientMock.create(),
    scopedClusterClient: _mocks.elasticsearchServiceMock.createScopedClusterClient(),
    share: {},
    shouldStopExecution: () => false,
    shouldWriteAlerts: () => shouldWriteAlerts,
    uiSettingsClient: _mocks.uiSettingsServiceMock.createClient()
  },
  state,
  previousStartedAt: null,
  namespace: undefined,
  executionId: 'b33f65d7-6e8b-4aae-8d20-c93613deb33f',
  logger,
  flappingSettings: _rules_settings.DEFAULT_FLAPPING_SETTINGS,
  getTimeRange: () => {
    const date = new Date(Date.now()).toISOString();
    return {
      dateStart: date,
      dateEnd: date
    };
  },
  isServerless: false
});
exports.createDefaultAlertExecutorOptions = createDefaultAlertExecutorOptions;