"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertGraphEvents = void 0;
var _uuid = require("uuid");
var _rxjs = require("rxjs");
var _agents = require("@kbn/onechat-common/agents");
var _langchain = require("@kbn/onechat-genai-utils/langchain");
var _convert_graph_events = require("../chat/convert_graph_events");
var _backlog = require("./backlog");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatPlanningResult = planning => {
  let formatted = `${planning.reasoning}\n`;
  if (planning.steps.length > 0) {
    formatted += `Plan:\n${planning.steps.map(step => ` - ${step}`).join('\n')}`;
  } else {
    formatted += `Plan: No remaining steps.`;
  }
  return formatted;
};
const convertGraphEvents = ({
  graphName,
  toolIdMapping
}) => {
  return streamEvents$ => {
    const messageId = (0, _uuid.v4)();
    const replay$ = streamEvents$.pipe((0, _rxjs.shareReplay)());
    return (0, _rxjs.merge)(
    // tool events from the sub agent
    replay$.pipe((0, _convert_graph_events.convertGraphEvents)({
      graphName: 'executor_agent',
      toolIdMapping
    }), (0, _rxjs.filter)(event => {
      return (0, _agents.isToolCallEvent)(event) || (0, _agents.isToolResultEvent)(event);
    })),
    // events from the planner
    replay$.pipe((0, _rxjs.mergeMap)(event => {
      if (!(0, _langchain.matchGraphName)(event, graphName)) {
        return _rxjs.EMPTY;
      }

      // create plan reasoning event
      if ((0, _langchain.matchEvent)(event, 'on_chain_end') && (0, _langchain.matchName)(event, 'create_plan')) {
        const {
          backlog
        } = event.data.output;
        const planningResult = (0, _backlog.lastPlanningResult)(backlog);
        const reasoningEvent = (0, _langchain.createReasoningEvent)(formatPlanningResult(planningResult));
        return (0, _rxjs.of)(reasoningEvent);
      }

      // revise plan reasoning event
      if ((0, _langchain.matchEvent)(event, 'on_chain_end') && (0, _langchain.matchName)(event, 'revise_plan')) {
        const {
          backlog
        } = event.data.output;
        const planningResult = (0, _backlog.lastPlanningResult)(backlog);
        const reasoningEvent = (0, _langchain.createReasoningEvent)(formatPlanningResult(planningResult));
        return (0, _rxjs.of)(reasoningEvent);
      }

      // answer step text chunks
      if ((0, _langchain.matchEvent)(event, 'on_chat_model_stream') && (0, _langchain.hasTag)(event, 'planner:answer')) {
        const chunk = event.data.chunk;
        const messageChunkEvent = (0, _langchain.createTextChunkEvent)(chunk, {
          defaultMessageId: messageId
        });
        return (0, _rxjs.of)(messageChunkEvent);
      }

      // answer step response message
      if ((0, _langchain.matchEvent)(event, 'on_chain_end') && (0, _langchain.matchName)(event, 'answer')) {
        const {
          generatedAnswer
        } = event.data.output;
        const messageEvent = (0, _langchain.createMessageEvent)(generatedAnswer);
        return (0, _rxjs.of)(messageEvent);
      }
      return _rxjs.EMPTY;
    })));
  };
};
exports.convertGraphEvents = convertGraphEvents;