"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitTrainedModelsService = useInitTrainedModelsService;
var _react = require("react");
var _rxjs = require("rxjs");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _storage = require("../../../../common/types/storage");
var _kibana = require("../../contexts/kibana");
var _toast_notification_service = require("../../services/toast_notification_service");
var _ml = require("../../contexts/ml");
var _hooks = require("../../components/node_available_warning/hooks");
var _ml_server_info = require("../../services/ml_server_info");
var _deployment_params_mapper = require("../deployment_params_mapper");
var _ml_telemetry_context = require("../../contexts/ml/ml_telemetry_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that initializes the shared TrainedModelsService instance with storage
 * for tracking active operations. The service is destroyed when no components
 * are using it and all operations are complete.
 */
function useInitTrainedModelsService() {
  const {
    services: {
      mlServices: {
        trainedModelsService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    telemetryClient
  } = (0, _ml_telemetry_context.useMlTelemetryClient)();
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const {
    nlpSettings
  } = (0, _ml.useMlServerInfo)();
  const cloudInfo = (0, _hooks.useCloudCheck)();
  const mlServerLimits = (0, _ml_server_info.getNewJobLimits)();
  const deploymentParamsMapper = (0, _react.useMemo)(() => new _deployment_params_mapper.DeploymentParamsMapper(mlServerLimits, cloudInfo, showNodeInfo, nlpSettings),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const defaultScheduledDeployments = (0, _react.useMemo)(() => [], []);
  const [scheduledDeployments, setScheduledDeployments] = (0, _mlLocalStorage.useStorage)(_storage.ML_SCHEDULED_MODEL_DEPLOYMENTS, defaultScheduledDeployments);
  const scheduledDeployments$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(scheduledDeployments),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  (0, _react.useEffect)(function initTrainedModelsService() {
    trainedModelsService.init({
      scheduledDeployments$,
      setScheduledDeployments,
      displayErrorToast,
      displaySuccessToast,
      telemetryService: telemetryClient,
      deploymentParamsMapper
    });
    return () => {
      trainedModelsService.destroy();
    };

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function syncSubject() {
    scheduledDeployments$.next(scheduledDeployments);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [scheduledDeployments, trainedModelsService]);
  return trainedModelsService;
}