"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateGroupNames = validateGroupNames;
exports.validateModelMemoryLimit = validateModelMemoryLimit;
var _ml_server_info = require("../../../services/ml_server_info");
var _util = require("../../new_job/common/job_validator/util");
var _job_utils = require("../../../../../common/util/job_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateModelMemoryLimit(mml) {
  const limits = (0, _ml_server_info.getNewJobLimits)();
  const tempJob = {
    analysis_limits: {
      model_memory_limit: mml
    }
  };
  let validationResults = (0, _job_utils.validateModelMemoryLimitUnits)(mml);
  let {
    valid
  } = validationResults;
  if (valid) {
    validationResults = (0, _job_utils.validateModelMemoryLimit)(tempJob, limits);
    valid = validationResults.valid;
  }
  const modelMemoryLimit = {
    valid,
    message: ''
  };
  (0, _util.populateValidationMessages)(validationResults, {
    modelMemoryLimit
  });
  return modelMemoryLimit;
}
function validateGroupNames(groups) {
  const tempJob = {
    groups
  };
  const validationResults = (0, _job_utils.validateGroupNames)(tempJob);
  const {
    valid
  } = validationResults;
  const groupIds = {
    valid,
    message: ''
  };
  (0, _util.populateValidationMessages)(validationResults, {
    groupIds
  });
  return groupIds;
}