"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaQuerySettings = void 0;
var _react = require("react");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKibanaQuerySettings = () => {
  const [allowLeadingWildcards] = (0, _public2.useUiSetting$)(_public.UI_SETTINGS.QUERY_ALLOW_LEADING_WILDCARDS);
  const [queryStringOptions] = (0, _public2.useUiSetting$)(_public.UI_SETTINGS.QUERY_STRING_OPTIONS);
  const [dateFormatTZ] = (0, _public2.useUiSetting$)(_public.UI_SETTINGS.DATEFORMAT_TZ);
  const [ignoreFilterIfFieldNotInIndex] = (0, _public2.useUiSetting$)(_public.UI_SETTINGS.COURIER_IGNORE_FILTER_IF_FIELD_NOT_IN_INDEX);
  return (0, _react.useMemo)(() => ({
    allowLeadingWildcards,
    queryStringOptions,
    dateFormatTZ,
    ignoreFilterIfFieldNotInIndex
  }), [allowLeadingWildcards, dateFormatTZ, ignoreFilterIfFieldNotInIndex, queryStringOptions]);
};
exports.useKibanaQuerySettings = useKibanaQuerySettings;