"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeControlEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _index_pattern_select_form_row = require("./index_pattern_select_form_row");
var _field_select = require("./field_select");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function filterField(field) {
  return field.type === 'number';
}
class RangeControlEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      IndexPatternSelect: null
    });
  }
  componentDidMount() {
    this.getIndexPatternSelect();
  }
  async getIndexPatternSelect() {
    const [, {
      unifiedSearch
    }] = await this.props.deps.core.getStartServices();
    this.setState({
      IndexPatternSelect: unifiedSearch.ui.IndexPatternSelect
    });
  }
  render() {
    const stepSizeId = `stepSize-${this.props.controlIndex}`;
    const decimalPlacesId = `decimalPlaces-${this.props.controlIndex}`;
    if (this.state.IndexPatternSelect === null) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_index_pattern_select_form_row.IndexPatternSelectFormRow, {
      indexPatternId: this.props.controlParams.indexPattern,
      onChange: this.props.handleIndexPatternChange,
      controlIndex: this.props.controlIndex,
      IndexPatternSelect: this.state.IndexPatternSelect
    }), /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
      fieldName: this.props.controlParams.fieldName,
      indexPatternId: this.props.controlParams.indexPattern,
      filterField: filterField,
      onChange: this.props.handleFieldNameChange,
      getIndexPattern: this.props.getIndexPattern,
      controlIndex: this.props.controlIndex
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: stepSizeId,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inputControl.editor.rangeControl.stepSizeLabel",
        defaultMessage: "Step Size"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: this.props.controlParams.options.step,
      onChange: event => {
        this.props.handleOptionsChange(this.props.controlIndex, 'step', event.target.valueAsNumber);
      },
      "data-test-subj": `rangeControlSizeInput${this.props.controlIndex}`
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: decimalPlacesId,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inputControl.editor.rangeControl.decimalPlacesLabel",
        defaultMessage: "Decimal Places"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      min: 0,
      value: this.props.controlParams.options.decimalPlaces,
      onChange: event => {
        this.props.handleOptionsChange(this.props.controlIndex, 'decimalPlaces', event.target.valueAsNumber);
      },
      "data-test-subj": `rangeControlDecimalPlacesInput${this.props.controlIndex}`
    })));
  }
}
exports.RangeControlEditor = RangeControlEditor;