"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _metadata_context = require("../containers/metadata_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELDS = [{
  field: 'cloud.instance.id',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.instanceId', {
    defaultMessage: 'Instance ID'
  })
}, {
  field: 'cloud.provider',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.cloudProvider', {
    defaultMessage: 'Cloud Provider'
  })
}, {
  field: 'host.os.name',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.operatinSystem', {
    defaultMessage: 'Operating System'
  })
}, {
  field: 'host.os.kernel',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.kernelVersion', {
    defaultMessage: 'Kernel Version'
  })
}, {
  field: 'host.hostname',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.hostname', {
    defaultMessage: 'Hostname'
  })
}, {
  field: 'host.containerized',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.containerized', {
    defaultMessage: 'Containerized'
  }),
  isBoolean: true
}, {
  field: 'cloud.project.id',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.projectId', {
    defaultMessage: 'Project ID'
  })
}, {
  field: 'cloud.availability_zone',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.availabilityZone', {
    defaultMessage: 'Availability Zone'
  })
}, {
  field: 'cloud.machine.type',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.machineType', {
    defaultMessage: 'Machine Type'
  })
}, {
  field: 'cloud.instance.name',
  label: _i18n.i18n.translate('xpack.infra.nodeDetails.labels.instanceName', {
    defaultMessage: 'Instance Name'
  })
}];
const getLabelForField = ({
  field
}) => {
  const fieldDef = FIELDS.find(f => f.field === field);
  if (!fieldDef) return field;
  return fieldDef.label;
};
const getValueForField = (metadata, {
  field,
  isBoolean
}) => {
  if (isBoolean) {
    return (0, _lodash.get)(metadata.info, field, false) ? _i18n.i18n.translate('xpack.infra.nodeDetails.yes', {
      defaultMessage: 'Yes'
    }) : _i18n.i18n.translate('xpack.infra.nodeDetails.no', {
      defaultMessage: 'No'
    });
  }
  const value = (0, _lodash.get)(metadata.info, field, '--');
  return value;
};
const NUMBER_OF_COLUMNS = 4;
const MetadataDetails = props => {
  const [isOpen, setControlState] = (0, _react.useState)(false);
  const toggleIsOpen = (0, _react.useCallback)(() => isOpen ? setControlState(false) : setControlState(true), [isOpen]);
  const filteredFields = (0, _react.useMemo)(() => {
    if (props.fields && props.fields.length) {
      return props.fields.map(field => {
        const fieldDef = FIELDS.find(f => f.field === field);
        if (fieldDef) {
          return fieldDef;
        }
      }).filter(f => f);
    } else {
      return FIELDS;
    }
  }, [props.fields]);
  const fields = (0, _react.useMemo)(() => isOpen ? filteredFields : filteredFields.slice(0, NUMBER_OF_COLUMNS), [filteredFields, isOpen]);
  const metadata = (0, _react.useContext)(_metadata_context.MetadataContext);
  if (!metadata) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(MetadataContainer, null, filteredFields.length > NUMBER_OF_COLUMNS ? /*#__PURE__*/_react.default.createElement(Controls, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraMetadataDetailsButton",
    iconType: isOpen ? 'arrowUp' : 'arrowDown',
    onClick: toggleIsOpen,
    "aria-label": _i18n.i18n.translate('xpack.infra.nodeDetails.labels.showMoreDetails', {
      defaultMessage: 'Show more details'
    })
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: NUMBER_OF_COLUMNS,
    style: {
      flexGrow: 1
    },
    gutterSize: "s"
  }, fields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field.field,
    style: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, getLabelForField(field))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, getValueForField(metadata, field))))));
};
exports.MetadataDetails = MetadataDetails;
const MetadataContainer = _styled.default.div`
  border-top: ${props => props.theme.euiTheme.border.thin};
  border-bottom: ${props => props.theme.euiTheme.border.thin};
  padding: ${props => props.theme.euiTheme.size.m} 0;
  margin-bottom: ${props => props.theme.euiTheme.size.m};
  display: flex;
`;
const Controls = _styled.default.div`
  flex-grow: 0;
  margin-right: ${props => props.theme.euiTheme.size.m};
  min-width: 0px;
`;