"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesMetadataPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _indices_metadata = require("./lib/services/indices_metadata");
var _events = require("./lib/ebt/events");
var _constants = require("./lib/constants");
var _artifact = require("./lib/services/artifact");
var _configuration = require("./lib/services/configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndicesMetadataPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config$", void 0);
    (0, _defineProperty2.default)(this, "indicesMetadataService", void 0);
    (0, _defineProperty2.default)(this, "configurationService", void 0);
    this.logger = context.logger.get();
    this.config$ = context.config.create();
    this.configurationService = new _configuration.ConfigurationService(this.logger);
    this.indicesMetadataService = new _indices_metadata.IndicesMetadataService(this.logger, this.configurationService);
  }
  setup(core, plugin) {
    const {
      taskManager
    } = plugin;
    this.indicesMetadataService.setup(taskManager);
    (0, _events.registerEbtEvents)(core.analytics);
  }
  start(core, plugin) {
    this.logger.debug('Starting indices metadata plugin');
    this.config$.subscribe(async pluginConfig => {
      this.logger.debug('PluginConfig changed', {
        pluginConfig
      });
      if (pluginConfig.enabled) {
        this.logger.info('Updating indices metadata configuration');
        const cdnConfig = this.effectiveCdnConfig(pluginConfig);
        const info = await core.elasticsearch.client.asInternalUser.info();
        const artifactService = new _artifact.ArtifactService(this.logger, info, cdnConfig);
        this.configurationService.start(artifactService, _constants.DEFAULT_INDICES_METADATA_CONFIGURATION);
        this.indicesMetadataService.start(plugin.taskManager, core.analytics, core.elasticsearch.client.asInternalUser);
      } else {
        this.logger.info('Indices metadata plugin is disabled, stopping services');
        this.configurationService.stop();
        this.indicesMetadataService.stop();
      }
    });
  }
  stop() {
    this.logger.debug('Stopping indices metadata plugin');
    this.indicesMetadataService.stop();
    this.configurationService.stop();
  }
  effectiveCdnConfig({
    cdn
  }) {
    var _cdn$url, _cdn$publicKey, _cdn$requestTimeout;
    return {
      url: (_cdn$url = cdn === null || cdn === void 0 ? void 0 : cdn.url) !== null && _cdn$url !== void 0 ? _cdn$url : _constants.DEFAULT_CDN_CONFIG.url,
      pubKey: (_cdn$publicKey = cdn === null || cdn === void 0 ? void 0 : cdn.publicKey) !== null && _cdn$publicKey !== void 0 ? _cdn$publicKey : _constants.DEFAULT_CDN_CONFIG.pubKey,
      requestTimeout: (_cdn$requestTimeout = cdn === null || cdn === void 0 ? void 0 : cdn.requestTimeout) !== null && _cdn$requestTimeout !== void 0 ? _cdn$requestTimeout : _constants.DEFAULT_CDN_CONFIG.requestTimeout
    };
  }
}
exports.IndicesMetadataPlugin = IndicesMetadataPlugin;