"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDismissableTour = useDismissableTour;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../constants");
var _use_core = require("./use_core");
var _use_tour_manager = require("./use_tour_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for managing dismissible tours in Fleet.
 * This uses the TourManager to ensure only one tour is displayed at a time.
 * @param tourKey - The key identifying the tour in storage
 * @param enabled - Additional condition that must be true for the tour to show
 */
function useDismissableTour(tourKey, enabled = true) {
  var _storage$get;
  const {
    storage,
    uiSettings
  } = (0, _use_core.useStartServices)();
  const {
    activeTour,
    setActiveTour
  } = (0, _use_tour_manager.useTourManager)();
  const defaultValue = uiSettings.get('hideAnnouncements', false) || ((_storage$get = storage.get(_constants.TOUR_STORAGE_KEYS[tourKey])) === null || _storage$get === void 0 ? void 0 : _storage$get.active) === false;
  const [isHidden, setIsHidden] = _react.default.useState(defaultValue);

  // Check if this tour should be shown (not hidden, enabled, and is the active tour or no tour manager)
  const isOpen = !isHidden && enabled && (activeTour === tourKey || activeTour === null);

  // Request to show this tour when it should be visible and no other tour is active
  _react.default.useEffect(() => {
    if (!isHidden && enabled && activeTour === null && setActiveTour) {
      setActiveTour(tourKey);
    }
  }, [isHidden, enabled, activeTour, setActiveTour, tourKey]);
  const dismiss = _react.default.useCallback(() => {
    setIsHidden(true);
    storage.set(_constants.TOUR_STORAGE_KEYS[tourKey], {
      active: false
    });
    // Clear this tour as active when dismissed
    if (activeTour === tourKey && setActiveTour) {
      setActiveTour(null);
    }
  }, [tourKey, storage, activeTour, setActiveTour]);
  return {
    isHidden,
    isOpen,
    dismiss
  };
}