"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _types = require("../../../definitions/types");
var _helpers = require("../../../shared/helpers");
var _complete_items = require("../../complete_items");
var _factories = require("../../factories");
var _helper = require("../../helper");
var _helper2 = require("./helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  innerText,
  getColumnsByType,
  columnExists,
  command
}) {
  const prependSpace = s => ({
    ...s,
    text: ' ' + s.text
  });
  const commandText = innerText.slice(command.location.min);
  const {
    pos,
    nulls
  } = (0, _helper2.getSortPos)(commandText);
  switch (pos) {
    case 'space2':
      {
        return [_helper2.sortModifierSuggestions.ASC, _helper2.sortModifierSuggestions.DESC, _helper2.sortModifierSuggestions.NULLS_FIRST, _helper2.sortModifierSuggestions.NULLS_LAST, _complete_items.pipeCompleteItem, {
          ..._complete_items.commaCompleteItem,
          text: ', ',
          command: _factories.TRIGGER_SUGGESTION_COMMAND
        }];
      }
    case 'order':
      {
        return (0, _helper.handleFragment)(innerText, fragment => ['ASC', 'DESC'].some(completeWord => (0, _helpers.noCaseCompare)(completeWord, fragment)), (_fragment, rangeToReplace) => {
          return Object.values(_helper2.sortModifierSuggestions).map(suggestion => ({
            ...suggestion,
            rangeToReplace
          }));
        }, (fragment, rangeToReplace) => {
          return [{
            ..._complete_items.pipeCompleteItem,
            text: ' | '
          }, {
            ..._complete_items.commaCompleteItem,
            text: ', '
          }, prependSpace(_helper2.sortModifierSuggestions.NULLS_FIRST), prependSpace(_helper2.sortModifierSuggestions.NULLS_LAST)].map(suggestion => ({
            ...suggestion,
            filterText: fragment,
            text: fragment + suggestion.text,
            rangeToReplace,
            command: _factories.TRIGGER_SUGGESTION_COMMAND
          }));
        });
      }
    case 'space3':
      {
        return [_helper2.sortModifierSuggestions.NULLS_FIRST, _helper2.sortModifierSuggestions.NULLS_LAST, _complete_items.pipeCompleteItem, {
          ..._complete_items.commaCompleteItem,
          text: ', ',
          command: _factories.TRIGGER_SUGGESTION_COMMAND
        }];
      }
    case 'nulls':
      {
        return (0, _helper.handleFragment)(innerText, fragment => ['FIRST', 'LAST'].some(completeWord => (0, _helpers.noCaseCompare)(completeWord, fragment)), _fragment => {
          const end = innerText.length + 1;
          const start = end - nulls.length;
          return Object.values(_helper2.sortModifierSuggestions).map(suggestion => ({
            ...suggestion,
            // we can't use the range generated by handleFragment here
            // because it doesn't really support multi-word completions
            rangeToReplace: {
              start,
              end
            }
          }));
        }, (fragment, rangeToReplace) => {
          return [{
            ..._complete_items.pipeCompleteItem,
            text: ' | '
          }, {
            ..._complete_items.commaCompleteItem,
            text: ', '
          }].map(suggestion => ({
            ...suggestion,
            filterText: fragment,
            text: fragment + suggestion.text,
            rangeToReplace,
            command: _factories.TRIGGER_SUGGESTION_COMMAND
          }));
        });
      }
    case 'space4':
      {
        return [_complete_items.pipeCompleteItem, {
          ..._complete_items.commaCompleteItem,
          text: ', ',
          command: _factories.TRIGGER_SUGGESTION_COMMAND
        }];
      }
  }
  const fieldSuggestions = await getColumnsByType('any', [], {
    openSuggestions: true
  });
  const functionSuggestions = await (0, _helper.getFieldsOrFunctionsSuggestions)(['any'], _types.Location.SORT, getColumnsByType, {
    functions: true,
    fields: false
  });
  return await (0, _helper.handleFragment)(innerText, columnExists, (_fragment, rangeToReplace) => {
    // SORT fie<suggest>
    return [...(0, _helper.pushItUpInTheList)(fieldSuggestions.map(suggestion => {
      // if there is already a command, we don't want to override it
      if (suggestion.command) return suggestion;
      return {
        ...suggestion,
        command: _factories.TRIGGER_SUGGESTION_COMMAND,
        rangeToReplace
      };
    }), true), ...functionSuggestions];
  }, (fragment, rangeToReplace) => {
    // SORT field<suggest>
    return [{
      ..._complete_items.pipeCompleteItem,
      text: ' | '
    }, {
      ..._complete_items.commaCompleteItem,
      text: ', '
    }, prependSpace(_helper2.sortModifierSuggestions.ASC), prependSpace(_helper2.sortModifierSuggestions.DESC), prependSpace(_helper2.sortModifierSuggestions.NULLS_FIRST), prependSpace(_helper2.sortModifierSuggestions.NULLS_LAST)].map(s => ({
      ...s,
      filterText: fragment,
      text: fragment + s.text,
      command: _factories.TRIGGER_SUGGESTION_COMMAND,
      rangeToReplace
    }));
  });
}