"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorSearchGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _elser = _interopRequireDefault(require("../../../../assets/images/elser.svg"));
var _nlp = _interopRequireDefault(require("../../../../assets/images/nlp.svg"));
var _doc_links = require("../../../shared/doc_links");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _dev_tools_console_code_block = require("../dev_tools_console_code_block/dev_tools_console_code_block");
var _page_template = require("../layout/page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_INDEX_SNIPPET = `PUT /my-index
{
  "mappings": {
    "properties": {
      "vector": {
        "type": "dense_vector",
        "dims": 3
      },
      "text": {
        "type": "text"
      }
    }
  }
}`;
const INGEST_SNIPPET = `POST /my-index/_doc
{
  "vector": [1, 5, -20],
  "text": "hello world"
}`;
const QUERY_SNIPPET = `POST /my-index/_search
{
  "size" : 3,
  "query" : {
    "knn": {
      "field": "vector",
      "query_vector": [1, 5, -20]
    }
  }
}`;
const VectorSearchGuide = () => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    application
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchVectorSearchPageTemplate, {
    "data-test-subj": "vectorSearchGuidePage",
    restrictWidth: true,
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.vectorSearch.guide.description",
        defaultMessage: "Elasticsearch can be used as a vector database, which enables vector search and semantic search use cases."
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.knnSearch,
        target: "_blank",
        "data-test-subj": "vector-search-documentation-link"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.vectorSearch.guide.descriptionLink",
        defaultMessage: "Learn more about vector search."
      }))),
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.vectorSearch.guide.pageTitle",
        defaultMessage: "Get started with vector search"
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetVectorSearchChrome, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.createIndex.title",
    defaultMessage: "Create an index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.createIndex.description",
    defaultMessage: "Start by creating an index with one or more {denseVector} fields.",
    values: {
      denseVector: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "dense_vector")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, CREATE_INDEX_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.ingest.title",
    defaultMessage: "Ingest your data"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.ingest.description",
    defaultMessage: "Add data to Elasticsearch."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, INGEST_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.query.title",
    defaultMessage: "Perform vector search"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.query.description",
    defaultMessage: "Now you're ready to explore your data with searches and aggregations."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, QUERY_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.title",
    defaultMessage: "Want to use semantic search?"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.description",
    defaultMessage: "Deploy ML models easily with Elastic Inference Endpoints to generate embeddings for your documents."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    onClick: () => {
      application.navigateToUrl(http.basePath.prepend(`${_constants.SEMANTIC_SEARCH_PLUGIN.URL}?model_example=elser`));
    },
    layout: "horizontal",
    titleSize: "s",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _elser.default,
      size: "xxl"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.elser.title",
      defaultMessage: "ELSER"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.elser.description",
      defaultMessage: "Learn about our model that enables semantic search without configuration"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    onClick: () => {
      application.navigateToUrl(http.basePath.prepend(`${_constants.SEMANTIC_SEARCH_PLUGIN.URL}?model_example=e5`));
    },
    layout: "horizontal",
    titleSize: "s",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _nlp.default,
      size: "xxl"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.byoModel.title",
      defaultMessage: "E5 Multilingual"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.vectorSearch.guide.deployedModel.byoModel.description",
      defaultMessage: "Use E5 to enable semantic search for multiple languages"
    })
  })))));
};
exports.VectorSearchGuide = VectorSearchGuide;