"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityRoute = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _kbn_url_state_context = require("../../utils/kbn_url_state_context");
var _use_breadcrumbs = require("../../utils/use_breadcrumbs");
var _use_kibana = require("../../utils/use_kibana");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasetQualityRoute = () => {
  const urlStateStorageContainer = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  const {
    services: {
      datasetQuality,
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _use_breadcrumbs.useBreadcrumbs)();
  return /*#__PURE__*/_react.default.createElement(_context.DatasetQualityContextProvider, {
    datasetQuality: datasetQuality,
    urlStateStorageContainer: urlStateStorageContainer,
    toastsService: notifications.toasts
  }, /*#__PURE__*/_react.default.createElement(ConnectedContent, null));
};
exports.DatasetQualityRoute = DatasetQualityRoute;
const ConnectedContent = /*#__PURE__*/_react.default.memo(() => {
  const {
    controller
  } = (0, _context.useDatasetQualityContext)();
  return controller ? /*#__PURE__*/_react.default.createElement(InitializedContent, {
    datasetQualityController: controller
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      logo: "logoKibana",
      size: "xl"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataQuality.Initializing",
      defaultMessage: "Initializing Data Set Quality page"
    })
  }));
});
const InitializedContent = /*#__PURE__*/_react.default.memo(({
  datasetQualityController
}) => {
  const {
    services: {
      datasetQuality
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  return /*#__PURE__*/_react.default.createElement(datasetQuality.DatasetQuality, {
    controller: datasetQualityController
  });
});