"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgSimpleForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tooltip_icon = require("../tooltip_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getRemoveAriaLabel: () => _i18n.i18n.translate('xpack.canvas.argFormArgSimpleForm.removeAriaLabel', {
    defaultMessage: 'Remove'
  }),
  getRequiredTooltip: () => _i18n.i18n.translate('xpack.canvas.argFormArgSimpleForm.requiredTooltip', {
    defaultMessage: 'This argument is required, you should specify a value.'
  })
};
// This is what is being generated by render() from the Arg class. It is called in FunctionForm
const ArgSimpleForm = ({
  children,
  required,
  valueMissing,
  onRemove
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    className: "canvasArg__form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), valueMissing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tooltip_icon.TooltipIcon, {
    position: "left",
    icon: _tooltip_icon.IconType.error,
    content: strings.getRequiredTooltip()
  })), !required && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: strings.getRemoveAriaLabel(),
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: onRemove,
    iconType: "cross",
    iconSize: "s",
    "aria-label": strings.getRemoveAriaLabel(),
    className: "canvasArg__remove"
  })));
};
exports.ArgSimpleForm = ArgSimpleForm;
ArgSimpleForm.propTypes = {
  children: _propTypes.default.node,
  required: _propTypes.default.bool,
  valueMissing: _propTypes.default.bool,
  onRemove: _propTypes.default.func.isRequired
};