"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetIntegrationFromRuleId = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_ARRAY = [];
/**
 * Hook that returns a package (integration) from a ruleId (value for the signal.rule.rule_id field), a list of rules and packages.
 * This hook is used in the GroupedAlertTable's accordion when grouping by signal.rule.rule_id (to render the title and statistics)
 * as well as the Integration column cell renderer.
 */
const useGetIntegrationFromRuleId = ({
  packages,
  ruleId,
  rules = EMPTY_ARRAY
}) => {
  // From the ruleId (which should be a value for a signal.rule.rule_id field) we find the rule
  // of the same id, which we then use its name to match a package's name.
  const integration = (0, _react.useMemo)(() => {
    const signalRuleId = Array.isArray(ruleId) ? ruleId[0] : ruleId;
    const rule = rules.find(r => r.rule_id === signalRuleId);
    if (!rule) {
      return undefined;
    }
    return packages.find(p => rule.related_integrations.map(ri => ri.package).includes(p.name));
  }, [packages, rules, ruleId]);
  return (0, _react.useMemo)(() => ({
    integration
  }), [integration]);
};
exports.useGetIntegrationFromRuleId = useGetIntegrationFromRuleId;