"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggedRequestsItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _formatted_date = require("../../../../common/components/formatted_date");
var _optimized_accordion = require("./optimized_accordion");
var _logged_requests_query = require("./logged_requests_query");
var _use_accordion_styling = require("./use_accordion_styling");
var _logged_requests_pages = require("./logged_requests_pages");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoggedRequestsItemComponent = ({
  startedAt,
  duration,
  requests = [],
  ruleType
}) => {
  const paddingLarge = (0, _eui.useEuiPaddingSize)('l');
  const cssStyles = (0, _use_accordion_styling.useAccordionStyling)();
  return /*#__PURE__*/_react.default.createElement(_optimized_accordion.OptimizedAccordion, {
    "data-test-subj": "preview-logged-requests-item-accordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startedAt ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.queryPreview.loggedRequestItemAccordionButtonLabel",
      defaultMessage: "Rule execution started at {time}.",
      values: {
        time: /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
          value: new Date(startedAt)
        })
      }
    }) : i18n.LOGGED_REQUEST_ITEM_ACCORDION_UNKNOWN_TIME_BUTTON, `[${duration}ms]`),
    id: `ruleExecution-${startedAt}`,
    css: (0, _react2.css)`
        margin-left: ${paddingLarge};
        ${cssStyles}
      `
  }, requests.length > 2 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "warning",
    size: "s",
    css: (0, _react2.css)`
              margin-left: ${paddingLarge};
            `
  }, i18n.REQUESTS_SAMPLE_WARNING), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null, (0, _logged_requests_pages.isPageViewSupported)(ruleType) ? /*#__PURE__*/_react.default.createElement(_logged_requests_pages.LoggedRequestsPages, {
    requests: requests,
    ruleType: ruleType
  }) : requests.map((request, key) => /*#__PURE__*/_react.default.createElement(_logged_requests_query.LoggedRequestsQuery, (0, _extends2.default)({
    key: key
  }, request))));
};
const LoggedRequestsItem = exports.LoggedRequestsItem = /*#__PURE__*/_react.default.memo(LoggedRequestsItemComponent);
LoggedRequestsItem.displayName = 'LoggedRequestsItem';