"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALIDATION_WARNING_CODE_FIELD_NAME_MAP = exports.VALIDATION_WARNING_CODES = void 0;
var _i18n = require("@kbn/i18n");
var _api = require("../../../common/hooks/eql/api");
var _esql_query_edit = require("../components/esql_query_edit");
var _error_codes = require("../components/threat_match_mapping_edit/validators/error_codes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESQL_FIELD_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.nonBlockingErrorCodes.esqlFieldName', {
  defaultMessage: 'ES|QL Query'
});
const EQL_FIELD_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.nonBlockingErrorCodes.eqlFieldName', {
  defaultMessage: 'EQL Query'
});
const THREAT_MATCH_MAPPING_FIELD_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.nonBlockingErrorCodes.threatMatchMapping', {
  defaultMessage: 'Indicator mapping'
});
const VALIDATION_WARNING_CODES = exports.VALIDATION_WARNING_CODES = [_esql_query_edit.ESQL_ERROR_CODES.INVALID_ESQL, _api.EQL_ERROR_CODES.FAILED_REQUEST, _api.EQL_ERROR_CODES.INVALID_EQL, _api.EQL_ERROR_CODES.MISSING_DATA_SOURCE, _error_codes.THREAT_MATCH_MAPPING_ERROR_CODES.ERR_FIELDS_UNKNOWN];
const VALIDATION_WARNING_CODE_FIELD_NAME_MAP = exports.VALIDATION_WARNING_CODE_FIELD_NAME_MAP = {
  [_esql_query_edit.ESQL_ERROR_CODES.INVALID_ESQL]: ESQL_FIELD_NAME,
  [_api.EQL_ERROR_CODES.FAILED_REQUEST]: EQL_FIELD_NAME,
  [_api.EQL_ERROR_CODES.INVALID_EQL]: EQL_FIELD_NAME,
  [_api.EQL_ERROR_CODES.MISSING_DATA_SOURCE]: EQL_FIELD_NAME,
  [_error_codes.THREAT_MATCH_MAPPING_ERROR_CODES.ERR_FIELDS_UNKNOWN]: THREAT_MATCH_MAPPING_FIELD_NAME
};